/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.upgrade.internal.orient.UpgradePoint;
import org.sonatype.nexus.upgrade.plan.Dependency;
import org.sonatype.nexus.upgrade.plan.DependencySource;

public class InitialStep
implements UpgradePoint,
DependencySource<UpgradePoint> {
    private final Map<String, String> modelVersions;

    public InitialStep(Map<String, String> modelVersions) {
        this.modelVersions = (Map)Preconditions.checkNotNull(modelVersions);
    }

    @Override
    public List<Dependency<UpgradePoint>> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public boolean satisfies(String model, String version) {
        return VersionComparator.INSTANCE.compare(this.modelVersions.getOrDefault(model, "1.0"), version) >= 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "modelVersions=" + this.modelVersions + '}';
    }
}

