/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal;

import java.sql.Connection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class DistributedEventsUpgrade
extends RepeatableDatabaseMigrationStep {
    private final boolean clusterEnabled;

    @Inject
    public DistributedEventsUpgrade(@Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean clusterEnabled) {
        this.clusterEnabled = clusterEnabled;
    }

    @Override
    public Integer getChecksum() {
        return this.clusterEnabled ? 1 : 0;
    }

    @Override
    public void migrate(Connection connection) throws Exception {
        if (this.clusterEnabled) {
            this.log.debug("Cluster enabled, skipping");
            return;
        }
        this.log.debug("Dropping distributed event table");
        this.runStatement(connection, "DROP TABLE IF EXISTS distributed_events");
    }
}

