/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal.steps;

import java.sql.Connection;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class PypiAssetMigrationStep_1_35
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String DROP_ASSETS = "DELETE FROM pypi_asset WHERE repository_id IN(SELECT cr.repository_id FROM pypi_content_repository cr LEFT JOIN repository AS r ON cr.config_repository_id = r.id WHERE r.recipe_name = 'pypi-group')";

    @Override
    public Optional<String> version() {
        return Optional.of("1.35");
    }

    @Override
    public void migrate(Connection connection) throws Exception {
        if (this.tableExists(connection, "pypi_asset") && this.tableExists(connection, "pypi_content_repository")) {
            this.log.info("Removing cached assets in pypi group repositories, regenerated with proper storage path on request.");
            this.runStatement(connection, DROP_ASSETS);
        }
    }
}

