/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal.audit;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeCompletedEvent;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeEventSupport;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeFailedEvent;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeStartedEvent;

@Named
@Singleton
public class UpgradeAuditor
extends AuditorSupport
implements EventAware,
EventAware.Asynchronous {
    public static final String DOMAIN = "database-migration";
    static final String COMPLETED = "completed";
    static final String FAILED = "failed";
    static final String STARTED = "started";
    static final String MIGRATIONS = "migrations";
    static final String NODE_IDS = "nodeIds";
    static final String MESSAGE = "message";
    static final String SCHEMA_VERSION = "schemaVersion";
    static final String NEXUS_VERSION = "nexusVersion";
    private final String nexusVersion;

    @Inject
    public UpgradeAuditor(ApplicationVersion applicationVersion) {
        this.nexusVersion = ((ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion)).getVersion();
        this.registerType(UpgradeCompletedEvent.class, COMPLETED);
        this.registerType(UpgradeFailedEvent.class, FAILED);
        this.registerType(UpgradeStartedEvent.class, STARTED);
    }

    @Subscribe
    public void on(UpgradeEventSupport event) {
        if (this.isRecording() && !EventHelper.isReplicating()) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(((Object)((Object)event)).getClass()));
            data.setContext("system");
            data.setInitiator(event.getUser().orElse("system"));
            Map attributes = data.getAttributes();
            attributes.put(NEXUS_VERSION, this.nexusVersion);
            event.getSchemaVersion().ifPresent(schemaVersion -> {
                String string = attributes.put(SCHEMA_VERSION, schemaVersion);
            });
            if (event instanceof UpgradeFailedEvent) {
                attributes.put(MESSAGE, ((UpgradeFailedEvent)event).getErrorMessage());
            } else {
                attributes.put(MIGRATIONS, event.getMigrations());
            }
            if (event instanceof UpgradeCompletedEvent) {
                attributes.put(NODE_IDS, ((UpgradeCompletedEvent)event).getNodeIds());
            }
            this.record(data);
        }
    }
}

