/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.output.MigrateResult;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;
import org.sonatype.nexus.upgrade.datastore.UpgradeException;
import org.sonatype.nexus.upgrade.datastore.UpgradeManager;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeCompletedEvent;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeFailedEvent;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeStartedEvent;
import org.sonatype.nexus.upgrade.datastore.internal.NexusJavaMigration;
import org.sonatype.nexus.upgrade.datastore.internal.PostStartupUpgradeAuditor;
import org.sonatype.nexus.upgrade.datastore.internal.SimpleDependencyResolver;
import org.sonatype.nexus.upgrade.datastore.internal.TraceLoggingCallback;

@Named
@Singleton
public class UpgradeManagerImpl
extends ComponentSupport
implements UpgradeManager {
    private final List<DatabaseMigrationStep> migrations;
    private final PostStartupUpgradeAuditor auditor;
    private final DataSource dataSource;

    @Inject
    public UpgradeManagerImpl(DataStoreManager dataStoreManager, PostStartupUpgradeAuditor auditor, List<DatabaseMigrationStep> migrations) {
        this.dataSource = ((DataStore)((DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager)).get("nexus").orElseThrow(() -> new IllegalStateException("Missing DataStore named: nexus"))).getDataSource();
        this.migrations = this.checkVersionedMigrations(migrations);
        this.auditor = (PostStartupUpgradeAuditor)((Object)Preconditions.checkNotNull((Object)((Object)auditor)));
    }

    @Override
    public void migrate(@Nullable String user, Collection<String> nodeIds) throws UpgradeException {
        MigrateResult result;
        Flyway flyway = this.createFlyway();
        MigrationInfoService info = flyway.info();
        this.checkSchemaVersionIsAcceptable(info);
        if (info.pending().length == 0) {
            this.log.debug("No pending migrations, skipping");
            return;
        }
        this.emitStarted(user, info);
        try {
            result = flyway.migrate();
        }
        catch (FlywayException e) {
            this.emitFailed(user, flyway, e.getMessage());
            throw new UpgradeException(e.getMessage(), e);
        }
        this.emitCompleted(user, nodeIds, result);
        int repeatableMigrations = this.migrations.size() - Long.valueOf(this.migrations.stream().map(DatabaseMigrationStep::version).filter(Optional::isPresent).count()).intValue();
        if (result.migrationsExecuted > repeatableMigrations) {
            result.migrations.forEach(m -> this.log.info("{} migrated to v{} in {}ms", new Object[]{m.description, m.version, m.executionTime}));
            result.warnings.forEach(arg_0 -> ((Logger)this.log).warn(arg_0));
            this.log.info("Completed migration from v{} to v{}", (Object)result.initialSchemaVersion, (Object)result.targetSchemaVersion);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("No migrations occurred migration of {} from {} to {}", new Object[]{result.schemaName, result.initialSchemaVersion, result.targetSchemaVersion});
        }
    }

    @Override
    public boolean requiresMigration() {
        return this.createFlyway().info().pending().length > 0;
    }

    @Override
    public Optional<MigrationVersion> getCurrentVersion() {
        return Optional.ofNullable(this.createFlyway().info().current()).map(MigrationInfo::getVersion);
    }

    @Override
    public void checkBaseline(String target) {
        Optional<MigrationVersion> version = this.getCurrentVersion();
        Optional<String> baseline = this.getBaseline(MigrationVersion.fromVersion((String)target));
        if (version.isPresent() && baseline.isPresent() && !version.get().isAtLeast(baseline.get())) {
            this.log.error("expected schema to be on baseline version (at least '{}') , shutting down", (Object)baseline.get());
            System.exit(1);
        }
    }

    @VisibleForTesting
    Optional<String> getBaseline(MigrationVersion target) {
        return this.migrations.stream().map(NexusJavaMigration::new).map(NexusJavaMigration::getVersion).filter(Objects::nonNull).filter(version -> version.getMajor().compareTo(target.getMajor()) < 0).sorted(Comparator.reverseOrder()).map(MigrationVersion::getVersion).findFirst();
    }

    @Override
    public Optional<MigrationVersion> getMaxMigrationVersion() {
        return Arrays.stream(this.getMigrations()).map(JavaMigration::getVersion).filter(Objects::nonNull).max(MigrationVersion::compareTo);
    }

    @Override
    public void checkSchemaVersionIsAcceptable() throws UpgradeException {
        this.checkSchemaVersionIsAcceptable(this.createFlyway().info());
    }

    private void checkSchemaVersionIsAcceptable(MigrationInfoService info) throws UpgradeException {
        List missingMigrations = Arrays.stream(info.applied()).filter(migrationInfo -> migrationInfo.getState() == MigrationState.FUTURE_SUCCESS).map(MigrationInfo::getDescription).collect(Collectors.toList());
        if (!missingMigrations.isEmpty()) {
            this.log.error("Missing migrations: {}", missingMigrations);
        }
        if (!missingMigrations.isEmpty()) {
            this.log.error("Missing migrations: {}", missingMigrations);
            throw new UpgradeException("The database appears to be from a later version of Nexus Repository");
        }
    }

    private void emitStarted(@Nullable String user, MigrationInfoService info) {
        this.auditor.post(new UpgradeStartedEvent(user, info.getInfoResult().schemaVersion, (String[])Arrays.stream(info.pending()).map(MigrationInfo::getDescription).toArray(String[]::new)));
    }

    private void emitFailed(@Nullable String user, Flyway flyway, String errorMessage) {
        this.auditor.post(new UpgradeFailedEvent(user, flyway.info().getInfoResult().schemaVersion, errorMessage, new String[0]));
    }

    private void emitCompleted(@Nullable String user, Collection<String> nodeIds, MigrateResult result) {
        if (result.migrationsExecuted > 0) {
            this.auditor.post(new UpgradeCompletedEvent(user, result.targetSchemaVersion, nodeIds, (String[])result.migrations.stream().map(m -> m.description).toArray(String[]::new)));
        }
    }

    private List<DatabaseMigrationStep> checkVersionedMigrations(List<DatabaseMigrationStep> migrations) {
        Preconditions.checkNotNull(migrations);
        List failures = migrations.stream().filter(migration -> migration.version().isPresent()).map(Object::getClass).map(Class::getName).filter(className -> !className.startsWith("org.sonatype")).collect(Collectors.toList());
        if (!failures.isEmpty()) {
            throw new IllegalArgumentException("The following migration steps are invalid: " + failures.stream().collect(Collectors.joining(", ")));
        }
        return migrations;
    }

    private Flyway createFlyway() {
        Callback[] callbackArray;
        JavaMigration[] flywayMigrations = this.getMigrations();
        if (this.log.isDebugEnabled()) {
            this.migrations.forEach(m -> this.log.debug("Found migration: {} version:{}", m.getClass(), m.version()));
        }
        FluentConfiguration fluentConfiguration = Flyway.configure().dataSource(this.dataSource).javaMigrations(flywayMigrations);
        if (this.log.isTraceEnabled()) {
            Callback[] callbackArray2 = new Callback[1];
            callbackArray = callbackArray2;
            callbackArray2[0] = new TraceLoggingCallback();
        } else {
            callbackArray = new Callback[]{};
        }
        return fluentConfiguration.callbacks(callbackArray).cleanDisabled(true).group(false).ignoreMigrationPatterns(new String[]{"*:missing"}).baselineOnMigrate(true).locations(new String[0]).outOfOrder(true).load();
    }

    private JavaMigration[] getMigrations() {
        return (JavaMigration[])new SimpleDependencyResolver(this.migrations).resolve().stream().toArray(JavaMigration[]::new);
    }
}

