/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;
import org.sonatype.nexus.upgrade.datastore.DependsOn;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;
import org.sonatype.nexus.upgrade.datastore.internal.NexusJavaMigration;

class SimpleDependencyResolver
extends ComponentSupport {
    private final Collection<DatabaseMigrationStep> steps;

    SimpleDependencyResolver(Collection<DatabaseMigrationStep> steps) {
        this.steps = (Collection)Preconditions.checkNotNull(steps);
    }

    Collection<NexusJavaMigration> resolve() {
        boolean found;
        LinkedHashMap orderedMap = new LinkedHashMap();
        this.steps.stream().filter(step -> step.version().isPresent()).forEach(step -> {
            NexusJavaMigration nexusJavaMigration = orderedMap.put(step.getClass(), new NexusJavaMigration((DatabaseMigrationStep)step));
        });
        this.steps.stream().filter(step -> !step.version().isPresent()).filter(step -> SimpleDependencyResolver.dependencies(step).isEmpty()).forEach(step -> {
            NexusJavaMigration nexusJavaMigration = orderedMap.put(step.getClass(), new NexusJavaMigration((DatabaseMigrationStep)step));
        });
        Map stepToDependency = this.steps.stream().filter(step -> !orderedMap.containsKey(step.getClass())).collect(Collectors.toMap(Function.identity(), SimpleDependencyResolver::dependencies));
        int round = 1;
        do {
            found = false;
            Iterator iter = stepToDependency.entrySet().iterator();
            HashMap roundMap = new HashMap();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!orderedMap.keySet().containsAll(entry.getValue())) continue;
                found = true;
                iter.remove();
                roundMap.put(((DatabaseMigrationStep)entry.getKey()).getClass(), new NexusJavaMigration((DatabaseMigrationStep)entry.getKey(), round));
            }
            orderedMap.putAll(roundMap);
            ++round;
        } while (found);
        if (!stepToDependency.isEmpty()) {
            this.log.error("Unable to compute dependencies for: {}", stepToDependency.keySet());
            throw new IllegalStateException("Unable to compute dependencies between upgrades");
        }
        return orderedMap.values();
    }

    private static List<Class<RepeatableDatabaseMigrationStep>> dependencies(DatabaseMigrationStep step) {
        return Stream.of((DependsOn[])step.getClass().getAnnotationsByType(DependsOn.class)).map(DependsOn::value).map(RepeatableDatabaseMigrationStep.class.getClass()::cast).collect(Collectors.toList());
    }
}

