/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal;

import com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeEventSupport;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class PostStartupUpgradeAuditor
extends StateGuardLifecycleSupport {
    private final Queue<UpgradeEventSupport> events = new ConcurrentLinkedQueue<UpgradeEventSupport>();
    private final EventManager eventManager;

    @Inject
    public PostStartupUpgradeAuditor(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    protected void doStart() {
        this.events.forEach(arg_0 -> ((EventManager)this.eventManager).post(arg_0));
        this.events.clear();
    }

    public void post(UpgradeEventSupport event) {
        if (!this.isStarted()) {
            this.events.add(event);
        } else {
            this.eventManager.post((Object)event);
        }
    }
}

