/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal;

import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.migration.Context;
import org.flywaydb.core.api.migration.JavaMigration;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

public class NexusJavaMigration
implements JavaMigration {
    private final DatabaseMigrationStep dbMigrationStep;
    private final Integer round;

    public NexusJavaMigration(DatabaseMigrationStep dbMigrationStep) {
        this(dbMigrationStep, null);
    }

    public NexusJavaMigration(DatabaseMigrationStep dbMigrationStep, Integer round) {
        this.dbMigrationStep = dbMigrationStep;
        this.round = round;
    }

    public boolean canExecuteInTransaction() {
        return this.dbMigrationStep.canExecuteInTransaction();
    }

    public Integer getChecksum() {
        return this.dbMigrationStep.getChecksum();
    }

    public String getDescription() {
        if (this.round != null) {
            return String.format("Z_%03d_%s", this.round, this.dbMigrationStep.getClass().getSimpleName());
        }
        return this.dbMigrationStep.getClass().getSimpleName();
    }

    public MigrationVersion getVersion() {
        return this.dbMigrationStep.version().map(MigrationVersion::fromVersion).orElse(null);
    }

    public boolean isBaselineMigration() {
        return false;
    }

    public boolean isUndo() {
        return false;
    }

    public void migrate(Context context) throws Exception {
        this.dbMigrationStep.migrate(context.getConnection());
    }
}

