/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.events;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.event.EventWithSource;

public abstract class UpgradeEventSupport
extends EventWithSource {
    private String user;
    private String schemaVersion;
    private String[] migrations;

    protected UpgradeEventSupport() {
    }

    protected UpgradeEventSupport(@Nullable String user, @Nullable String schemaVersion, String[] migrations) {
        this.user = user;
        this.schemaVersion = schemaVersion;
        this.migrations = (String[])Preconditions.checkNotNull((Object)migrations);
    }

    public String[] getMigrations() {
        return this.migrations;
    }

    public Optional<String> getSchemaVersion() {
        return Optional.ofNullable(this.schemaVersion);
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public void setMigrations(String[] migrations) {
        this.migrations = migrations;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

