/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DatabaseMigrationUtility {
    public boolean isH2(Connection conn) throws SQLException {
        return "H2".equals(conn.getMetaData().getDatabaseProductName());
    }

    public boolean isPostgresql(Connection conn) throws SQLException {
        return "PostgreSQL".equals(conn.getMetaData().getDatabaseProductName());
    }

    /*
     * Exception decompiling
     */
    public boolean tableExists(Connection conn, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public boolean columnExists(Connection conn, String tableName, String columnName) throws SQLException {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE UPPER(TABLE_NAME) = ? AND UPPER(COLUMN_NAME) = ?";
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            boolean bl;
            ResultSet results;
            Throwable throwable2;
            block19: {
                statement.setString(1, tableName.toUpperCase());
                statement.setString(2, columnName.toUpperCase());
                throwable2 = null;
                Object var9_12 = null;
                results = statement.executeQuery();
                bl = results.next();
                if (results == null) break block19;
                results.close();
            }
            return bl;
            {
                catch (Throwable throwable3) {
                    try {
                        if (results != null) {
                            results.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public boolean indexExists(Connection conn, String indexName) throws SQLException {
        if (this.isPostgresql(conn)) {
            String currentSchema = this.currentSchema(conn);
            String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE UPPER(constraint_name) = ?   AND UPPER(constraint_schema) = ?";
            Throwable throwable = null;
            Object var6_12 = null;
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                boolean bl;
                ResultSet results;
                Throwable throwable2;
                block40: {
                    statement.setString(1, indexName.toUpperCase());
                    statement.setString(2, currentSchema.toUpperCase());
                    throwable2 = null;
                    Object var9_22 = null;
                    results = statement.executeQuery();
                    bl = results.next();
                    if (results == null) break block40;
                    results.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (results != null) {
                                results.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (this.isH2(conn)) {
            String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE UPPER(constraint_name) = ?";
            Throwable throwable = null;
            Object var5_10 = null;
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                boolean bl;
                ResultSet results;
                Throwable throwable6;
                block41: {
                    statement.setString(1, indexName.toUpperCase());
                    throwable6 = null;
                    Object var8_20 = null;
                    results = statement.executeQuery();
                    bl = results.next();
                    if (results == null) break block41;
                    results.close();
                }
                return bl;
                {
                    catch (Throwable throwable7) {
                        try {
                            if (results != null) {
                                results.close();
                            }
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            if (throwable6 == null) {
                                throwable6 = throwable8;
                            } else if (throwable6 != throwable8) {
                                throwable6.addSuppressed(throwable8);
                            }
                            throw throwable6;
                        }
                    }
                }
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    throwable = throwable9;
                } else if (throwable != throwable9) {
                    throwable.addSuppressed(throwable9);
                }
                throw throwable;
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String currentSchema(Connection conn) throws SQLException {
        String sql = "select current_schema()";
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            ResultSet results;
            block14: {
                Throwable throwable2 = null;
                Object var7_10 = null;
                try {
                    String string;
                    results = statement.executeQuery();
                    try {
                        if (!results.next()) break block14;
                        string = results.getString(1);
                        if (results == null) return string;
                    }
                    catch (Throwable throwable3) {
                        if (results == null) throw throwable3;
                        results.close();
                        throw throwable3;
                    }
                    results.close();
                    return string;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            if (results == null) throw new IllegalStateException("Unable to determine current database schema");
            results.close();
            throw new IllegalStateException("Unable to determine current database schema");
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }
}

