/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.datastore;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;

@Named
@Singleton
public class AssetBlobRefFormatCheck
extends ComponentSupport {
    private final Map<String, FormatStoreManager> formatStoreManagers;

    @Inject
    public AssetBlobRefFormatCheck(Map<String, FormatStoreManager> formatStoreManagers) {
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
    }

    public boolean isAssetBlobRefNotMigrated(Repository repository) {
        String dataStoreName = this.getDataStoreName(repository);
        String format = repository.getFormat().getValue();
        boolean notMigrated = Optional.ofNullable(this.formatStoreManagers.get(format)).map(storeManager -> storeManager.assetBlobStore(dataStoreName)).map(assetBlobStore -> ((AssetBlobStore)assetBlobStore).notMigratedAssetBlobRefsExists()).orElseThrow(() -> new RuntimeException("Cannot determine asset blob ref migration status"));
        if (notMigrated) {
            this.log.warn("Cannot restore {} repository '{}' because legacy blob ref migration is not complete.", (Object)repository.getFormat().getValue(), (Object)repository.getName());
        }
        return notMigrated;
    }

    private String getDataStoreName(Repository repository) {
        return Optional.of(repository.getConfiguration()).map(configuration -> configuration.attributes("storage")).map(attr -> (String)attr.get("dataStoreName", String.class)).orElse("nexus");
    }
}

