/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

public abstract class RestoreBlobData {
    private final Blob blob;
    private final Properties blobProperties;
    private final BlobStore blobStore;
    private final Repository repository;

    protected RestoreBlobData(Blob blob, Properties blobProperties, BlobStore blobStore, RepositoryManager repositoryManager) {
        Preconditions.checkNotNull((Object)repositoryManager);
        Preconditions.checkNotNull((Object)blobProperties);
        this.blob = blob;
        this.blobProperties = blobProperties;
        this.blobStore = blobStore;
        this.repository = repositoryManager.get((String)Preconditions.checkNotNull((Object)this.getProperty("@Bucket.repo-name"), (Object)"Blob properties missing repository name"));
    }

    public Blob getBlob() {
        return this.blob;
    }

    public String getBlobName() {
        return this.getProperty("@BlobStore.blob-name");
    }

    public String getBlobType() {
        return this.getProperty("@BlobStore.content-type");
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public final String getProperty(String propertyName) {
        return this.blobProperties.getProperty(propertyName);
    }
}

