/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.metrics.reconcile;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.common.BlobStoreTaskSupport;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;

@AvailabilityVersion(from="1.0")
@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY)
public class RecalculateBlobStoreSizeTask
extends BlobStoreTaskSupport
implements Cancelable {
    private static final int LOGGING_INTERVAL = 60;
    private static final String S3_TYPE = "S3";
    private static final int CANCEL_CHECK_INTERVAL = 300;

    @Inject
    public RecalculateBlobStoreSizeTask(BlobStoreManager blobStoreManager) {
        super(blobStoreManager);
    }

    public String getMessage() {
        return String.format("recalculate blob store storage for '%s'", this.getBlobStoreField());
    }

    @Override
    protected void execute(BlobStore blobStore) {
        DateTime currentDate = DateTime.now();
        boolean includeSoftDeleted = !blobStore.getBlobStoreConfiguration().getType().equals(S3_TYPE);
        BlobStoreMetricsService metricsService = blobStore.getMetricsService();
        metricsService.clearCountMetrics();
        AtomicLong totalSize = new AtomicLong();
        AtomicLong totalCount = new AtomicLong();
        Throwable throwable = null;
        Object var8_9 = null;
        try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
            blobStore.getBlobIdStream().map(arg_0 -> ((BlobStore)blobStore).getBlobAttributes(arg_0)).filter(Objects::nonNull).filter(attributes -> this.isCreatedBefore((BlobAttributes)attributes, currentDate)).filter(attributes -> includeSoftDeleted || !attributes.isDeleted()).map(attributes -> attributes.getMetrics().getContentSize()).forEach(blobSize -> {
                totalSize.addAndGet((long)blobSize);
                metricsService.recordAddition(blobSize.longValue());
                if (totalCount.incrementAndGet() % 300L == 0L) {
                    CancelableHelper.checkCancellation();
                }
                progressLogger.info("Re-calculating size metrics on blob store '{}', size : {} - blobs count : {}", new Object[]{blobStore.getBlobStoreConfiguration().getName(), totalSize, totalCount});
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected boolean appliesTo(BlobStore blobStore) {
        return !blobStore.getBlobStoreConfiguration().getType().equals("Group");
    }

    private boolean isCreatedBefore(BlobAttributes attributes, DateTime date) {
        return attributes.getMetrics().getCreationTime().isBefore((ReadableInstant)date);
    }
}

