/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.metrics;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsEntity;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsPropertiesReader;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsStore;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class BlobStoreMetricsMigrationService
extends StateGuardLifecycleSupport {
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreMetricsStore metricsStore;
    private final Map<String, BlobStoreMetricsPropertiesReader> metricsPropertiesReaders;

    @Inject
    public BlobStoreMetricsMigrationService(BlobStoreManager blobStoreManager, BlobStoreMetricsStore metricsStore, Map<String, BlobStoreMetricsPropertiesReader> metricsPropertiesReaders) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.metricsStore = (BlobStoreMetricsStore)Preconditions.checkNotNull((Object)metricsStore);
        this.metricsPropertiesReaders = (Map)Preconditions.checkNotNull(metricsPropertiesReaders);
    }

    protected void doStart() throws Exception {
        this.blobStoreManager.browse().forEach(blobStore -> {
            String blobStoreName = blobStore.getBlobStoreConfiguration().getName();
            String blobStoreType = blobStore.getBlobStoreConfiguration().getType();
            if (!blobStore.isStarted()) {
                this.log.info("Blob store {}:{} is not started, skipping it.", (Object)blobStoreType, (Object)blobStoreName);
                return;
            }
            try {
                BlobStoreMetricsEntity metricsFromDb = this.metricsStore.get(blobStoreName);
                if (this.shouldSaveMetricsToDatabase(metricsFromDb)) {
                    BlobStoreMetricsPropertiesReader propertiesReader = this.metricsPropertiesReaders.get(blobStoreType);
                    if (propertiesReader == null) {
                        this.log.error("Properties reader not found for {}:{}", (Object)blobStoreType, (Object)blobStoreName);
                        return;
                    }
                    propertiesReader.initWithBlobStore(blobStore);
                    BlobStoreMetrics metricsFromFile = propertiesReader.readMetrics();
                    Map operationMetrics = propertiesReader.readOperationMetrics();
                    if (metricsFromFile != null && operationMetrics != null) {
                        this.log.debug("Found metrics {} for {}:{} should be migrated to DB", new Object[]{metricsFromDb, blobStoreType, blobStoreName});
                        this.metricsStore.initializeMetrics(blobStoreName);
                        this.metricsStore.updateMetrics(this.toBlobStoreMetricsEntity(blobStoreName, metricsFromFile, operationMetrics));
                    }
                }
            }
            catch (Exception exception) {
                this.log.error("Exception during migrating metrics from properties to DB for {}:{}", (Object)blobStoreType, (Object)blobStoreName);
            }
        });
    }

    private boolean shouldSaveMetricsToDatabase(BlobStoreMetricsEntity metricsFromDb) {
        return metricsFromDb == null || metricsFromDb.getBlobCount() == 0L;
    }

    private BlobStoreMetricsEntity toBlobStoreMetricsEntity(String blobStoreName, BlobStoreMetrics blobStoreMetrics, Map<OperationType, OperationMetrics> operationMetrics) {
        OperationMetrics downloadMetrics = operationMetrics.get(OperationType.DOWNLOAD);
        OperationMetrics uploadMetrics = operationMetrics.get(OperationType.UPLOAD);
        return new BlobStoreMetricsEntity().setBlobStoreName(blobStoreName).setBlobCount(blobStoreMetrics.getBlobCount()).setTotalSize(blobStoreMetrics.getTotalSize()).setDownloadBlobSize(downloadMetrics.getBlobSize()).setDownloadErrorRequests(downloadMetrics.getErrorRequests()).setDownloadSuccessfulRequests(downloadMetrics.getSuccessfulRequests()).setDownloadTimeOnRequests(downloadMetrics.getTimeOnRequests()).setUploadBlobSize(uploadMetrics.getBlobSize()).setUploadErrorRequests(uploadMetrics.getErrorRequests()).setUploadSuccessfulRequests(uploadMetrics.getSuccessfulRequests()).setUploadTimeOnRequests(uploadMetrics.getTimeOnRequests());
    }
}

