/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.metrics;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.metrics.MonitoringBlobStoreMetrics;

public class BlobStoreAnalyticsInterceptor
extends ComponentSupport
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String clazz = invocation.getThis().getClass().getSimpleName();
        Method method = invocation.getMethod();
        String methodName = method.getName();
        MonitoringBlobStoreMetrics metricsAnnotation = method.getAnnotation(MonitoringBlobStoreMetrics.class);
        Preconditions.checkState((metricsAnnotation != null ? 1 : 0) != 0);
        OperationType operationType = metricsAnnotation.operationType();
        if (!(invocation.getThis() instanceof BlobStore)) {
            this.log.info("Can't monitor operation metrics for class={}, methodName={}", (Object)clazz, (Object)methodName);
            return invocation.proceed();
        }
        BlobStore blobStore = (BlobStore)invocation.getThis();
        OperationMetrics operationMetrics = (OperationMetrics)blobStore.getOperationMetricsDelta().get(operationType);
        long start = System.currentTimeMillis();
        try {
            Object result = invocation.proceed();
            operationMetrics.addSuccessfulRequest();
            operationMetrics.addTimeOnRequests(System.currentTimeMillis() - start);
            if (result instanceof BlobSupport) {
                long totalSize = ((BlobSupport)result).getMetrics().getContentSize();
                operationMetrics.addBlobSize(totalSize);
            }
            return result;
        }
        catch (Exception e) {
            operationMetrics.addErrorRequest();
            throw e;
        }
    }
}

