/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.internal.datastore;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@FeatureFlag(name="nexus.datastore.enabled")
public class DefaultBlobStoreUsageChecker
implements BlobStoreUsageChecker {
    private final RepositoryManager repositoryManager;

    @Inject
    public DefaultBlobStoreUsageChecker(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Timed
    public boolean test(BlobStore blobStore, BlobId blobId, String blobName) {
        return Optional.of(blobId).map(arg_0 -> ((BlobStore)blobStore).get(arg_0)).map(Blob::getHeaders).map(headers -> (String)headers.get("Bucket.repo-name")).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).map(repository -> (ContentFacetSupport)repository.facet(ContentFacet.class)).flatMap(contentFacetSupport -> {
            String blobStoreName = blobStore.getBlobStoreConfiguration().getName();
            BlobRef blobRef = new BlobRef(contentFacetSupport.nodeName(), blobStoreName, blobId.asUniqueString());
            return contentFacetSupport.stores().assetBlobStore.readAssetBlob(blobRef);
        }).isPresent();
    }
}

