/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.deletetemp;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class DeleteBlobstoreTempFilesTask
extends TaskSupport
implements Cancelable {
    private final BlobStoreManager blobStoreManager;

    @Inject
    public DeleteBlobstoreTempFilesTask(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    protected Object execute() throws Exception {
        BlobStore blobStore = this.blobStoreManager.get(this.getBlobStoreField());
        if (blobStore != null) {
            int daysOlderThan = this.getDaysOlderThan() == null ? 0 : Integer.parseInt(this.getDaysOlderThan());
            blobStore.deleteTempFiles(Integer.valueOf(daysOlderThan));
        } else {
            this.log.warn("Unable to find blob store: {}", (Object)this.getBlobStoreField());
        }
        return null;
    }

    public String getMessage() {
        return "Deleting " + this.getBlobStoreField() + " blob store temporary files";
    }

    private String getBlobStoreField() {
        return this.getConfiguration().getString("blobstoreName");
    }

    private String getDaysOlderThan() {
        return this.getConfiguration().getString("olderThanDays");
    }
}

