/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.compact.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.scheduling.TaskUtils;

@Named
public class CompactBlobStoreTask
extends TaskSupport
implements Cancelable {
    private final BlobStoreManager blobStoreManager;
    private final Optional<ChangeRepositoryBlobStoreStore> changeBlobstoreStore;
    private final BlobStoreUsageChecker blobStoreUsageChecker;
    private final TaskUtils taskUtils;

    @Inject
    public CompactBlobStoreTask(BlobStoreManager blobStoreManager, @Nullable ChangeRepositoryBlobStoreStore changeBlobstoreStore, BlobStoreUsageChecker blobStoreUsageChecker, TaskUtils taskUtils) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.changeBlobstoreStore = Optional.ofNullable(changeBlobstoreStore);
        this.blobStoreUsageChecker = (BlobStoreUsageChecker)Preconditions.checkNotNull((Object)blobStoreUsageChecker);
        this.taskUtils = (TaskUtils)Preconditions.checkNotNull((Object)taskUtils);
    }

    @VisibleForTesting
    void checkForConflicts() {
        String blobStoreName = (String)Preconditions.checkNotNull((Object)this.getBlobStoreField());
        this.taskUtils.checkForConflictingTasks(this.getId(), this.getName(), Arrays.asList("repository.move"), (Map)ImmutableMap.of((Object)"moveInitialBlobstore", Arrays.asList(blobStoreName), (Object)"moveTargetBlobstore", Arrays.asList(blobStoreName)));
        this.checkForUnfinishedMoveTask(blobStoreName);
    }

    private void checkForUnfinishedMoveTask(String blobStoreName) {
        List existingMoves = this.changeBlobstoreStore.map(store -> store.findByBlobStoreName(blobStoreName)).orElseGet(Collections::emptyList);
        if (!existingMoves.isEmpty()) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "found {} unfinished move tasks using blobstore '{}', unable to run task '{}'", new Object[]{existingMoves.size(), blobStoreName, this.getName()});
            throw new IllegalStateException(String.format("found unfinished move task(s) using blobstore '%s', task can't be executed", blobStoreName));
        }
    }

    protected Object execute() throws Exception {
        this.checkForConflicts();
        BlobStore blobStore = this.blobStoreManager.get(this.getBlobStoreField());
        if (blobStore != null) {
            blobStore.compact(this.blobStoreUsageChecker);
        } else {
            this.log.warn("Unable to find blob store: {}", (Object)this.getBlobStoreField());
        }
        return null;
    }

    public String getMessage() {
        return "Compacting " + this.getBlobStoreField() + " blob store";
    }

    private String getBlobStoreField() {
        return this.getConfiguration().getString("blobstoreName");
    }
}

