/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.common;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;

public abstract class BlobStoreTaskSupport
extends TaskSupport {
    public static final String BLOBSTORE_NAME_FIELD_ID = "blobstoreName";
    public static final String ALL = "(All Blob Stores)";
    protected final BlobStoreManager blobStoreManager;

    protected BlobStoreTaskSupport(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    protected BlobStoreTaskSupport(boolean taskLoggingEnabled, BlobStoreManager blobStoreManager) {
        super(taskLoggingEnabled);
        this.blobStoreManager = blobStoreManager;
    }

    protected Object execute() throws Exception {
        int processedBlobStores = 0;
        MultipleFailures failures = new MultipleFailures();
        for (BlobStore blobStore : this.findBlobStores()) {
            if (this.isCanceled()) break;
            String blobstoreName = blobStore.getBlobStoreConfiguration().getName();
            try {
                this.log.info("processing blob store '{}'", (Object)blobstoreName);
                this.execute(blobStore);
                this.log.info("successfully processed blob store '{}'", (Object)blobstoreName);
                ++processedBlobStores;
            }
            catch (TaskInterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Failure processing blobstore '{}'", (Object)blobstoreName, (Object)e);
                failures.add((Throwable)e);
            }
        }
        this.log.info("finished task '{}' - processed blob stores : {}", (Object)this.getMessage(), (Object)processedBlobStores);
        failures.maybePropagate(String.format("Failure running task '%s", this.getMessage()));
        return null;
    }

    private Iterable<BlobStore> findBlobStores() {
        String blobStoreField = this.getBlobStoreField();
        String[] names = blobStoreField.split(",");
        if (Arrays.asList(names).contains(ALL)) {
            return Iterables.filter((Iterable)this.blobStoreManager.browse(), this::appliesTo);
        }
        return Arrays.stream(names).map(arg_0 -> ((BlobStoreManager)this.blobStoreManager).get(arg_0)).filter(Objects::nonNull).filter(this::appliesTo).collect(Collectors.toSet());
    }

    protected String getBlobStoreField() {
        return this.getConfiguration().getString(BLOBSTORE_NAME_FIELD_ID);
    }

    protected abstract boolean appliesTo(BlobStore var1);

    protected abstract void execute(BlobStore var1);
}

