/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCrowdServiceException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.entity.ErrorEntity;
import com.atlassian.crowd.integration.rest.service.CrowdRestException;
import com.atlassian.crowd.integration.rest.service.util.ShutdownIgnoringMultiThreadedHttpConnectionManager;
import com.atlassian.crowd.service.client.ClientProperties;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestExecutor {
    private static final String INVALID_REST_SERVICE_MSG_FORMAT = "The following URL does not specify a valid Crowd User Management REST service: %s";
    private static final String EMBEDDED_CROWD_VERSION_NAME = "X-Embedded-Crowd-Version";
    private static final Logger logger = LoggerFactory.getLogger(RestExecutor.class);
    private final ShutdownIgnoringMultiThreadedHttpConnectionManager connectionManager = new ShutdownIgnoringMultiThreadedHttpConnectionManager();
    private final String baseUrl;
    private final HttpClient client;
    private static final Pattern HTML_CONTENT_TYPE = Pattern.compile("text/html(\\s*;.*)?", 2);
    private static final Pattern UP_TO_HTML_BODY = Pattern.compile(".*<body[^>]*>", 32);

    RestExecutor(ClientProperties clientProperties) {
        try {
            URI uri = new URI(clientProperties.getBaseURL(), false);
            this.baseUrl = RestExecutor.createBaseUrl(clientProperties.getBaseURL());
            this.client = new HttpClient((HttpConnectionManager)this.connectionManager);
            this.client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(clientProperties.getApplicationName(), clientProperties.getApplicationPassword());
            this.client.getState().setCredentials(new AuthScope(uri.getHost(), -1), (Credentials)credentials);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(NumberUtils.toInt((String)clientProperties.getHttpTimeout(), (int)5000));
            this.client.getHttpConnectionManager().getParams().setSoTimeout(NumberUtils.toInt((String)clientProperties.getSocketTimeout(), (int)600000));
            this.client.getHttpConnectionManager().getParams().setMaxTotalConnections(NumberUtils.toInt((String)clientProperties.getHttpMaxConnections(), (int)20));
            this.client.getHttpConnectionManager().getParams().setMaxConnectionsPerHost(this.client.getHostConfiguration(), NumberUtils.toInt((String)clientProperties.getHttpMaxConnections(), (int)this.client.getHttpConnectionManager().getParams().getMaxTotalConnections()));
            this.initProxyConfiguration(clientProperties, this.client);
        }
        catch (URIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void initProxyConfiguration(ClientProperties clientProperties, HttpClient client) {
        if (clientProperties.getHttpProxyHost() != null) {
            client.getHostConfiguration().setProxy(clientProperties.getHttpProxyHost(), NumberUtils.toInt((String)clientProperties.getHttpProxyPort(), (int)-1));
            if (clientProperties.getHttpProxyUsername() != null && clientProperties.getHttpProxyPassword() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(clientProperties.getHttpProxyUsername(), clientProperties.getHttpProxyPassword());
                client.getState().setProxyCredentials(new AuthScope(clientProperties.getHttpProxyHost(), -1), (Credentials)credentials);
            }
        }
    }

    private static String createBaseUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        if (url.endsWith("/")) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("/rest/usermanagement/1");
        return sb.toString();
    }

    MethodExecutor get(String format, Object ... args) {
        return new MethodExecutor((HttpMethod)new GetMethod(RestExecutor.buildUrl(this.baseUrl, format, args)));
    }

    MethodExecutor delete(String format, Object ... args) {
        return new MethodExecutor((HttpMethod)new DeleteMethod(RestExecutor.buildUrl(this.baseUrl, format, args)));
    }

    MethodExecutor postEmpty(String format, Object ... args) {
        PostMethod method = new PostMethod(RestExecutor.buildUrl(this.baseUrl, format, args));
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity("", "application/xml", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new MethodExecutor((HttpMethod)method);
    }

    MethodExecutor post(Object body, String format, Object ... args) {
        PostMethod method = new PostMethod(RestExecutor.buildUrl(this.baseUrl, format, args));
        RestExecutor.setBody((EntityEnclosingMethod)method, body);
        return new MethodExecutor((HttpMethod)method);
    }

    MethodExecutor put(Object body, String format, Object ... args) {
        PutMethod method = new PutMethod(RestExecutor.buildUrl(this.baseUrl, format, args));
        RestExecutor.setBody((EntityEnclosingMethod)method, body);
        return new MethodExecutor((HttpMethod)method);
    }

    private static void setBody(EntityEnclosingMethod method, Object body) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        JAXB.marshal((Object)body, (OutputStream)bs);
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bs.toByteArray(), "application/xml"));
    }

    static String buildUrl(String baseUrl, String format, Object ... args) {
        Object[] encodedArgs = new Object[args.length];
        int pathArgCount = RestExecutor.pathArgumentCount(format);
        try {
            int i;
            for (i = 0; i < pathArgCount; ++i) {
                encodedArgs[i] = args[i] instanceof String ? URIUtil.encodeWithinPath((String)((String)args[i])) : args[i];
            }
            for (i = pathArgCount; i < args.length; ++i) {
                encodedArgs[i] = args[i] instanceof String ? URIUtil.encodeWithinQuery((String)((String)args[i])) : args[i];
            }
            String url = baseUrl + String.format(format, encodedArgs);
            logger.debug("Constructed " + url);
            return url;
        }
        catch (URIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static int pathArgumentCount(String format) {
        int queryStart = format.indexOf(63);
        if (queryStart == -1) {
            queryStart = format.length();
        }
        int count = 0;
        int i = format.indexOf(37);
        while (i != -1 && i < queryStart) {
            ++count;
            i = format.indexOf(37, i + 1);
        }
        return count;
    }

    void shutDown() {
        this.connectionManager.reallyShutdown();
    }

    static String getExceptionMessageFromResponse(HttpMethod method) throws IOException {
        Header h = method.getResponseHeader("Content-Type");
        if (h != null && HTML_CONTENT_TYPE.matcher(h.getValue()).matches()) {
            return RestExecutor.stripHtml(method.getResponseBodyAsString());
        }
        return method.getResponseBodyAsString();
    }

    static String stripHtml(String s) {
        String onlyTheBody = UP_TO_HTML_BODY.matcher(s).replaceAll("");
        String withoutTags = onlyTheBody.replaceAll("<[^>]*>", "");
        return StringUtils.normalizeSpace((String)StringEscapeUtils.unescapeHtml4((String)withoutTags));
    }

    class MethodExecutor {
        final HttpMethod method;
        final Set<Integer> statusCodesWithoutErrorEntity;

        MethodExecutor(HttpMethod method) {
            this(method, (Set<Integer>)ImmutableSet.of());
        }

        MethodExecutor(HttpMethod method, Set<Integer> statusCodesWithoutErrorEntity) {
            this.method = method;
            this.statusCodesWithoutErrorEntity = statusCodesWithoutErrorEntity;
        }

        public MethodExecutor ignoreErrorEntityForStatusCode(int statusCode) {
            ImmutableSet newStatusCodesWithoutErrorEntity = ImmutableSet.builder().addAll(this.statusCodesWithoutErrorEntity).add((Object)statusCode).build();
            return new MethodExecutor(this.method, (Set<Integer>)newStatusCodesWithoutErrorEntity);
        }

        <T> T andReceive(Class<T> returnType) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            this.method.setRequestHeader("Accept", "application/xml");
            try {
                int statusCode = this.executeCrowdServiceMethod(this.method);
                if (!this.isSuccess(statusCode)) {
                    this.throwError(statusCode);
                    throw new OperationFailedException(this.method.getStatusText());
                }
                Object object = JAXB.unmarshal((InputStream)this.method.getResponseBodyAsStream(), returnType);
                return (T)object;
            }
            catch (IOException e) {
                throw new OperationFailedException(e);
            }
            finally {
                this.method.releaseConnection();
            }
        }

        boolean doesExist() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            try {
                int statusCode = this.executeCrowdServiceMethod(this.method);
                if (this.isSuccess(statusCode)) {
                    boolean bl = true;
                    return bl;
                }
                if (statusCode == 404) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.throwError(statusCode);
                    throw new OperationFailedException(this.method.getStatusText());
                }
                catch (IOException e) {
                    throw new OperationFailedException(e);
                }
            }
            finally {
                this.method.releaseConnection();
            }
        }

        void andCheckResponse() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            this.method.setRequestHeader("Accept", "application/xml");
            try {
                int statusCode = this.executeCrowdServiceMethod(this.method);
                if (!this.isSuccess(statusCode)) {
                    this.throwError(statusCode);
                    throw new OperationFailedException(this.method.getStatusText());
                }
            }
            catch (IOException e) {
                throw new OperationFailedException(e);
            }
            finally {
                this.method.releaseConnection();
            }
        }

        private boolean isSuccess(int statusCode) {
            return statusCode >= 200 && statusCode < 300;
        }

        int executeCrowdServiceMethod(HttpMethod method) throws InvalidCrowdServiceException, IOException {
            int statusCode = RestExecutor.this.client.executeMethod(method);
            if (!this.isCrowdRestService(method)) {
                throw new InvalidCrowdServiceException(String.format(RestExecutor.INVALID_REST_SERVICE_MSG_FORMAT, method.getURI().toString()));
            }
            return statusCode;
        }

        private boolean isCrowdRestService(HttpMethod method) {
            return method.getResponseHeader(RestExecutor.EMBEDDED_CROWD_VERSION_NAME) != null;
        }

        void throwError(int errorCode) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            try {
                if (errorCode == 403) {
                    throw new ApplicationPermissionException(RestExecutor.getExceptionMessageFromResponse(this.method));
                }
                if (errorCode == 401) {
                    throw new InvalidAuthenticationException(RestExecutor.getExceptionMessageFromResponse(this.method));
                }
                if (errorCode >= 300) {
                    if (this.statusCodesWithoutErrorEntity.contains(errorCode)) {
                        throw new CrowdRestException("HTTP error: " + errorCode + " " + this.method.getStatusText() + ". Response body: " + this.method.getResponseBodyAsString(), null, errorCode);
                    }
                    ErrorEntity errorEntity = (ErrorEntity)JAXB.unmarshal((InputStream)this.method.getResponseBodyAsStream(), ErrorEntity.class);
                    throw new CrowdRestException(errorEntity.getMessage(), errorEntity, this.method.getStatusCode());
                }
            }
            catch (IOException e) {
                throw new OperationFailedException(this.method.getStatusText());
            }
            catch (DataBindingException dbe) {
                throw new OperationFailedException(this.method.getStatusText());
            }
        }
    }
}

