/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasklog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLogHome;

@Named
@Singleton
public class TaskLogCleanup
extends ComponentSupport {
    private final Integer numberOfDays;
    private String taskLogHome;

    @Inject
    public TaskLogCleanup(@Named(value="${nexus.tasks.log.cleanup.numberOfDays:-30}") @Named(value="${nexus.tasks.log.cleanup.numberOfDays:-30}") Integer numberOfDays) {
        this.numberOfDays = (Integer)Preconditions.checkNotNull((Object)numberOfDays);
    }

    void cleanup() {
        String taskLogsHome = this.getTaskLogHome();
        if (taskLogsHome == null) {
            this.log.warn("Unable to cleanup task log files. Please check that the 'tasklogfile' appender exists in logback.xml");
            return;
        }
        File logFilesHome = new File(taskLogsHome);
        this.log.info("Cleaning up log files in {} older than {} days", (Object)logFilesHome.getAbsolutePath(), (Object)this.numberOfDays);
        LocalDate now = LocalDate.now().minusDays(this.numberOfDays.intValue());
        Date thresholdDate = Date.from(now.atStartOfDay(ZoneId.systemDefault()).toInstant());
        AgeFileFilter ageFileFilter = new AgeFileFilter(thresholdDate);
        Iterator filesToDelete = FileUtils.iterateFiles((File)logFilesHome, (IOFileFilter)ageFileFilter, (IOFileFilter)ageFileFilter);
        filesToDelete.forEachRemaining(f -> {
            try {
                FileUtils.forceDelete((File)f);
                this.log.info("Removed task log file {}", (Object)f.toString());
            }
            catch (IOException e) {
                this.log.error("Unable to delete task file {}. Message was {}.", (Object)f.toString(), (Object)e.getMessage());
            }
        });
    }

    @VisibleForTesting
    String getTaskLogHome() {
        if (this.taskLogHome == null) {
            this.taskLogHome = TaskLogHome.getTaskLogsHome();
        }
        return this.taskLogHome;
    }
}

