/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal.describe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.repository.httpbridge.internal.describe.Description;
import org.sonatype.nexus.repository.httpbridge.internal.describe.DescriptionRenderer;

@Named
@Singleton
public class DescriptionRendererImpl
implements DescriptionRenderer {
    private static final String TEMPLATE_RESOURCE = "describeHtml.vm";
    private final TemplateHelper templateHelper;
    private final ObjectMapper objectMapper;
    private final URL template;

    @Inject
    public DescriptionRendererImpl(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.template = this.getClass().getResource(TEMPLATE_RESOURCE);
        Preconditions.checkNotNull((Object)this.template);
    }

    @Override
    public String renderHtml(Description description) {
        TemplateParameters params = this.templateHelper.parameters();
        params.setAll(description.getParameters());
        params.set("items", description.getItems());
        params.set("esc", (Object)new EscapeHelper());
        return this.templateHelper.render(this.template, params);
    }

    @Override
    public String renderJson(Description description) {
        try {
            return this.objectMapper.writeValueAsString((Object)description);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

