/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.httpbridge.internal.HttpBridgeServletModule;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;

@Named
@FeatureFlag(name="nexus.session.enabled")
public class HttpBridgeModule
extends AbstractModule {
    public static final String MOUNT_POINT = "/repository";

    protected void configure() {
        this.install((Module)new HttpBridgeServletModule(){

            @Override
            protected void bindSecurityFilter(ServletModule.FilterKeyBindingBuilder filter) {
                filter.through(SecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/repository/**", new String[]{"nx-authc", "nx-apikey-authc", "nx-anonymous", "nx-anticsrf-authc"});
            }
        });
    }
}

