/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudBlobStore;
import com.sonatype.nexus.blobstore.gcloud.internal.rest.GoogleCloudBlobstoreApiModel;
import com.sonatype.nexus.blobstore.gcloud.internal.rest.GoogleCloudBlobstoreApiResourceDoc;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Named
@Singleton
@Path(value="/v1/blobstores/google")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GoogleCloudBlobstoreApiResource
extends ComponentSupport
implements Resource,
GoogleCloudBlobstoreApiResourceDoc {
    static final String RESOURCE_URI = "/v1/blobstores/google";
    static final int ONE_MILLION = 1000000;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public GoogleCloudBlobstoreApiResource(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    @Override
    @GET
    @RequiresAuthentication
    @Path(value="/{name}")
    @RequiresPermissions(value={"nexus:blobstores:read"})
    public GoogleCloudBlobstoreApiModel get(@PathParam(value="name") String name) {
        BlobStore blobStore = this.blobStoreManager.get(name);
        if (blobStore == null) {
            return null;
        }
        BlobStoreConfiguration config = this.confirmType(blobStore.getBlobStoreConfiguration());
        return new GoogleCloudBlobstoreApiModel(config);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:create"})
    public GoogleCloudBlobstoreApiModel create(@Valid GoogleCloudBlobstoreApiModel model) throws Exception {
        if (this.blobStoreManager.get(model.getName()) != null) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "A blob store with that name already exists");
        }
        BlobStoreConfiguration config = this.blobStoreManager.newConfiguration();
        config.setType("Google Cloud Storage");
        this.merge(config, model);
        BlobStore blobStore = this.blobStoreManager.create(config);
        return new GoogleCloudBlobstoreApiModel(blobStore.getBlobStoreConfiguration());
    }

    @Override
    @PUT
    @RequiresAuthentication
    @Path(value="/{name}")
    @RequiresPermissions(value={"nexus:blobstores:update"})
    public GoogleCloudBlobstoreApiModel update(@PathParam(value="name") String name, @Valid GoogleCloudBlobstoreApiModel model) throws Exception {
        BlobStore existing = this.blobStoreManager.get(name);
        if (existing == null) {
            return null;
        }
        BlobStoreConfiguration config = this.confirmType(existing.getBlobStoreConfiguration());
        this.merge(config, model);
        BlobStore blobStore = this.blobStoreManager.update(config);
        return new GoogleCloudBlobstoreApiModel(blobStore.getBlobStoreConfiguration());
    }

    BlobStoreConfiguration confirmType(BlobStoreConfiguration config) {
        if (!"Google Cloud Storage".equals(config.getType())) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "Use this API only for blob stores with type Google Cloud Storage");
        }
        return config;
    }

    void merge(BlobStoreConfiguration config, GoogleCloudBlobstoreApiModel blobstoreApiModel) {
        config.setName(blobstoreApiModel.getName());
        NestedAttributesMap bucket = config.attributes(GoogleCloudBlobStore.CONFIG_KEY);
        bucket.set("bucketName", (Object)blobstoreApiModel.getBucketName());
        bucket.set("region", (Object)blobstoreApiModel.getRegion());
        bucket.set("credentialFilePath", (Object)blobstoreApiModel.getCredentialFilePath());
        if (blobstoreApiModel.getSoftQuota() != null) {
            NestedAttributesMap softQuota = config.attributes("blobStoreQuotaConfig");
            softQuota.set("quotaType", Preconditions.checkNotNull((Object)blobstoreApiModel.getSoftQuota().getType()));
            Long softQuotaLimit = (Long)Preconditions.checkNotNull((Object)blobstoreApiModel.getSoftQuota().getLimit());
            softQuota.set("quotaLimitBytes", (Object)(softQuotaLimit * 1000000L));
        }
    }
}

