/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal.rest;

import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudBlobStore;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public class GoogleCloudBlobstoreApiModel {
    @NotBlank
    @ApiModelProperty(value="The name of the blob store")
    private String name;
    @NotBlank
    @ApiModelProperty(value="The name of the bucket in Google Cloud Storage")
    private String bucketName;
    @NotBlank
    @ApiModelProperty(value="The name of the region where the bucket is stored, e.g. us-central1")
    private String region;
    @ApiModelProperty(value="Settings to control the soft quota.")
    private BlobStoreApiSoftQuota softQuota;
    @ApiModelProperty(value="Path to the Google Application Credentials file")
    private String credentialFilePath;

    public GoogleCloudBlobstoreApiModel() {
    }

    GoogleCloudBlobstoreApiModel(BlobStoreConfiguration configuration) {
        NestedAttributesMap softQuotaAttributes;
        this.name = configuration.getName();
        this.bucketName = (String)configuration.attributes(GoogleCloudBlobStore.CONFIG_KEY).get("bucketName", String.class);
        this.region = (String)configuration.attributes(GoogleCloudBlobStore.CONFIG_KEY).get("region", String.class);
        if (StringUtils.isNotBlank((String)((String)configuration.attributes(GoogleCloudBlobStore.CONFIG_KEY).get("credentialFilePath", String.class)))) {
            this.credentialFilePath = "<path is configured>";
        }
        if ((softQuotaAttributes = configuration.attributes("blobStoreQuotaConfig")) != null) {
            BlobStoreApiSoftQuota softQuota = new BlobStoreApiSoftQuota();
            softQuota.setLimit((Long)configuration.attributes("blobStoreQuotaConfig").get("quotaLimitBytes", Long.class));
            softQuota.setType((String)configuration.attributes("blobStoreQuotaConfig").get("quotaType", String.class));
            this.softQuota = softQuota;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public BlobStoreApiSoftQuota getSoftQuota() {
        return this.softQuota;
    }

    public void setSoftQuota(BlobStoreApiSoftQuota softQuota) {
        this.softQuota = softQuota;
    }

    public String getCredentialFilePath() {
        return this.credentialFilePath;
    }

    public void setCredentialFilePath(String credentialFilePath) {
        this.credentialFilePath = credentialFilePath;
    }
}

