/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Transaction;
import com.google.cloud.datastore.Value;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.util.concurrent.RateLimiter;
import com.google.datastore.v1.TransactionOptions;
import com.sonatype.nexus.blobstore.gcloud.GoogleCloudProjectException;
import com.sonatype.nexus.blobstore.gcloud.internal.DatastoreKeyHierarchy;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudDatastoreFactory;
import com.sonatype.nexus.blobstore.gcloud.internal.Namespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;

class ShardedCounterMetricsStore
extends ComponentSupport {
    private static final String METRICS_STORE = "MetricsStore";
    static final String SHARD = "MetricsStoreShard";
    private static final String COUNT = "count";
    private static final String SIZE = "size";
    private final BlobIdLocationResolver locationResolver;
    private final GoogleCloudDatastoreFactory datastoreFactory;
    private Datastore datastore;
    private Key shardRoot;
    private Queue<Mutation> pending = new ConcurrentLinkedDeque<Mutation>();
    private final RateLimiter rateLimiter;
    private String namespace;
    private BlobStoreConfiguration blobStoreConfiguration;
    private Map<OperationType, OperationMetrics> operationMetrics = new EnumMap<OperationType, OperationMetrics>(OperationType.class);
    static final int DEFAULT_FLUSH_DELAY_SECONDS = 1;

    ShardedCounterMetricsStore(BlobIdLocationResolver locationResolver, GoogleCloudDatastoreFactory datastoreFactory, BlobStoreConfiguration blobStoreConfiguration) {
        this(locationResolver, datastoreFactory, blobStoreConfiguration, 1);
    }

    ShardedCounterMetricsStore(BlobIdLocationResolver locationResolver, GoogleCloudDatastoreFactory datastoreFactory, BlobStoreConfiguration blobStoreConfiguration, int flushDelaySeconds) {
        this.locationResolver = locationResolver;
        this.datastoreFactory = datastoreFactory;
        this.blobStoreConfiguration = blobStoreConfiguration;
        this.rateLimiter = RateLimiter.create((double)flushDelaySeconds);
    }

    void initialize() throws Exception {
        this.datastore = this.datastoreFactory.create(this.blobStoreConfiguration);
        this.namespace = "blobstore-" + Namespace.safe(this.blobStoreConfiguration.getName());
        this.shardRoot = ((KeyFactory)((KeyFactory)((KeyFactory)this.datastore.newKeyFactory().addAncestors(DatastoreKeyHierarchy.NXRM_ROOT, new PathElement[0])).setNamespace(this.namespace)).setKind(METRICS_STORE)).newKey(1L);
        OperationType[] operationTypeArray = OperationType.values();
        int n = operationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperationType type = operationTypeArray[n2];
            this.operationMetrics.put(type, new OperationMetrics());
            ++n2;
        }
        try {
            this.getMetrics();
        }
        catch (DatastoreException e) {
            throw new GoogleCloudProjectException("Check that Firestore is configured for datastore mode, not native mode ", e);
        }
        try {
            this.test();
        }
        catch (DatastoreException e) {
            throw new GoogleCloudProjectException("unable to write metrics metadata", e);
        }
    }

    void test() throws DatastoreException {
        BlobId sentinel = new BlobId("tmp$/sentinel");
        Key key = ((KeyFactory)this.datastore.newKeyFactory().setKind(METRICS_STORE)).newKey(sentinel.asUniqueString());
        Entity entity = Entity.newBuilder((Key)this.shardRoot).setKey(key).build();
        this.datastore.put((FullEntity)entity);
        this.datastore.delete(new Key[]{key});
    }

    void removeData() {
        this.log.warn("removing all Blobstore metrics data from datastore...");
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getShards(), 16), false).forEach(shardKey -> this.datastore.delete(new Key[]{shardKey}));
        this.log.warn("Blobstore metrics data removed");
    }

    void recordDeletion(BlobId blobId, long size) {
        String shard = this.getShardLocation(blobId);
        this.pending.add(new Mutation(shard, -size, -1L));
    }

    void recordAddition(BlobId blobId, long size) {
        String shard = this.getShardLocation(blobId);
        this.pending.add(new Mutation(shard, size, 1L));
    }

    public BlobStoreMetrics getMetrics() {
        Long count = this.getCount(COUNT);
        Long size = this.getCount(SIZE);
        return new GoogleBlobStoreMetrics(count, size);
    }

    Map<OperationType, OperationMetrics> getOperationMetricsByType() {
        return this.operationMetrics;
    }

    private Long getCount(String fieldName) {
        Transaction txn = this.datastore.newTransaction(TransactionOptions.newBuilder().setReadOnly(TransactionOptions.ReadOnly.newBuilder().build()).build());
        try {
            ProjectionEntityQuery countQuery = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.newProjectionEntityQueryBuilder().setKind(SHARD)).setNamespace(this.namespace)).setProjection(fieldName, new String[0]).build();
            QueryResults results = this.datastore.run((Query)countQuery);
            Long l = StreamSupport.stream(Spliterators.spliteratorUnknownSize(results, 256), false).map(entity -> entity.getLong(fieldName)).reduce(0L, (valueA, valueB) -> valueA + valueB);
            return l;
        }
        finally {
            if (txn.isActive()) {
                txn.rollback();
            }
        }
    }

    private Entity getShardCounter(String location) {
        KeyFactory keyFactory = (KeyFactory)this.datastore.newKeyFactory().addAncestors(DatastoreKeyHierarchy.NXRM_ROOT, new PathElement[]{PathElement.of((String)METRICS_STORE, (long)1L)});
        Key key = ((KeyFactory)((KeyFactory)keyFactory.setNamespace(this.namespace)).setKind(SHARD)).newKey(location);
        Entity exists = this.datastore.get(key);
        if (exists != null) {
            this.log.trace("counter for {} already present", (Object)location);
            return exists;
        }
        this.log.debug("creating metrics store counter shard for {}", (Object)location);
        Entity entity = ((Entity.Builder)((Entity.Builder)Entity.newBuilder((Key)key).set(SIZE, (Value)LongValue.newBuilder((long)0L).build())).set(COUNT, (Value)LongValue.newBuilder((long)0L).build())).build();
        return this.datastore.put((FullEntity)entity);
    }

    private String getShardLocation(BlobId blobId) {
        String location = this.locationResolver.getLocation(blobId);
        if (!location.contains("/")) {
            throw new IllegalArgumentException(String.format("unexpected BlobId LocationStrategy; %s does not contain a '/'", blobId));
        }
        return StringUtils.split((String)location, (String)"/")[0];
    }

    private QueryResults<Key> getShards() {
        KeyQuery shardQuery = ((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)Query.newKeyQueryBuilder().setFilter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)this.shardRoot))).setNamespace(this.namespace)).setKind(SHARD)).build();
        return this.datastore.run((Query)shardQuery);
    }

    void flush() {
        if (!this.pending.isEmpty()) {
            this.log.debug("flush started for namespace {} attempting to acquire permit", (Object)this.namespace);
            double wait = this.rateLimiter.acquire();
            this.log.debug("permit acquired for namespace {} after {} seconds", (Object)this.namespace, (Object)wait);
            ArrayListMultimap toWrite = ArrayListMultimap.create();
            Mutation queued = this.pending.poll();
            while (queued != null) {
                toWrite.put((Object)queued.getShard(), (Object)queued);
                queued = this.pending.poll();
            }
            ArrayList list = new ArrayList();
            for (String shard : toWrite.keySet()) {
                Collection deltas = toWrite.get((Object)shard);
                deltas.stream().reduce((deltaA, deltaB) -> new Mutation(shard, deltaA.getSizeDelta() + deltaB.getSizeDelta(), deltaA.getCountDelta() + deltaB.getCountDelta())).ifPresent(merged -> {
                    Entity shardCounter = this.getShardCounter(merged.getShard());
                    FullEntity entity = ((FullEntity.Builder)((FullEntity.Builder)FullEntity.newBuilder((IncompleteKey)((Key)shardCounter.getKey())).set(SIZE, shardCounter.getLong(SIZE) + merged.getSizeDelta())).set(COUNT, shardCounter.getLong(COUNT) + merged.getCountDelta())).build();
                    list.add(entity);
                });
            }
            this.log.debug("sending {} mutations to datastore for namespace {}", (Object)list.size(), (Object)this.namespace);
            this.log.trace("sending {} mutations to datastore for namespace {}", list, (Object)this.namespace);
            if (!list.isEmpty()) {
                Transaction txn = this.datastore.newTransaction();
                try {
                    txn.put(list.toArray(new FullEntity[list.size()]));
                    txn.commit();
                    this.log.debug("drained {} mutations to datastore for namespace {}", (Object)list.size(), (Object)this.namespace);
                }
                finally {
                    if (txn.isActive()) {
                        txn.rollback();
                        this.log.debug("flush failed for namespace {}, transaction rolled back", (Object)this.namespace);
                        this.pending.addAll(toWrite.values());
                    }
                }
            }
        }
    }

    class GoogleBlobStoreMetrics
    implements BlobStoreMetrics {
        private final long blobCount;
        private final long totalSize;

        GoogleBlobStoreMetrics(long blobCount, long totalSize) {
            this.blobCount = blobCount;
            this.totalSize = totalSize;
        }

        public long getBlobCount() {
            return this.blobCount;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public final long getAvailableSpace() {
            return 0L;
        }

        public final boolean isUnlimited() {
            return true;
        }

        public final Map<String, Long> getAvailableSpaceByFileStore() {
            return Collections.emptyMap();
        }

        public boolean isUnavailable() {
            return false;
        }

        public String toString() {
            return "GoogleBlobStoreMetrics{blobCount=" + this.blobCount + ", totalSize=" + this.totalSize + '}';
        }
    }

    class Mutation {
        private final String shard;
        private final long sizeDelta;
        private final long countDelta;

        Mutation(String shard, long sizeDelta, long countDelta) {
            this.shard = shard;
            this.sizeDelta = sizeDelta;
            this.countDelta = countDelta;
        }

        public String getShard() {
            return this.shard;
        }

        public long getSizeDelta() {
            return this.sizeDelta;
        }

        public long getCountDelta() {
            return this.countDelta;
        }

        public String toString() {
            return "Mutation{shard='" + this.shard + '\'' + ", sizeDelta=" + this.sizeDelta + ", countDelta=" + this.countDelta + '}';
        }
    }
}

