/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sonatype.nexus.blobstore.gcloud.internal.Uploader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class MultipartUploader
extends StateGuardLifecycleSupport
implements Uploader {
    public static final String CHUNK_SIZE_PROPERTY = "nexus.gcs.multipartupload.chunksize";
    static final int COMPOSE_REQUEST_LIMIT = 32;
    private final String CHUNK_NAME_PART = ".chunk";
    private static final byte[] EMPTY = new byte[0];
    private final ListeningExecutorService executorService;
    private final int chunkSize;
    private final Histogram numberOfChunks;
    private final Counter composeLimitHitCounter;

    @Inject
    public MultipartUploader(MetricRegistry metricRegistry, @Named(value="${nexus.gcs.multipartupload.chunksize:-0}") @Named(value="${nexus.gcs.multipartupload.chunksize:-0}") int chunkSize) {
        Preconditions.checkArgument((chunkSize >= 0 ? 1 : 0) != 0, (Object)"nexus.gcs.multipartupload.chunksize cannot be negative");
        this.chunkSize = chunkSize;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)new InstrumentedExecutorService(Executors.newCachedThreadPool((ThreadFactory)new NexusThreadFactory("multipart-upload", "nexus-blobstore-google-cloud")), metricRegistry, String.format("%s.%s", MultipartUploader.class.getName(), "executor-service")));
        this.numberOfChunks = metricRegistry.histogram(MetricRegistry.name(MultipartUploader.class, (String[])new String[]{"chunks"}));
        this.composeLimitHitCounter = metricRegistry.counter(MetricRegistry.name(MultipartUploader.class, (String[])new String[]{"composeLimitHits"}));
    }

    protected void doStart() {
        if (this.isParallel()) {
            this.log.info("parallel upload to Google Cloud Storage enabled with buffer size {}", (Object)this.getChunkSize());
        }
    }

    protected void doStop() {
        this.executorService.shutdownNow();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public long getNumberOfTimesComposeLimitHit() {
        return this.composeLimitHitCounter.getCount();
    }

    public boolean isParallel() {
        return this.getChunkSize() > 0;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Blob upload(Storage storage, String bucket, String destination, InputStream contents) {
        if (this.isParallel()) {
            return this.parallelUpload(storage, bucket, destination, contents);
        }
        this.log.debug("Starting upload for destination {} in bucket {}", (Object)destination, (Object)bucket);
        BlobInfo blobInfo = BlobInfo.newBuilder((String)bucket, (String)destination).build();
        Blob result = storage.create(blobInfo, contents, new Storage.BlobWriteOption[]{Storage.BlobWriteOption.disableGzipContent()});
        this.log.debug("Upload of {} complete", (Object)destination);
        return result;
    }

    Blob parallelUpload(Storage storage, String bucket, String destination, InputStream contents) {
        this.log.debug("Starting parallel multipart upload for destination {} in bucket {}", (Object)destination, (Object)bucket);
        ArrayList<String> chunkNames = new ArrayList<String>();
        Optional<Blob> singleChunk = Optional.empty();
        try {
            Blob blob;
            block20: {
                Throwable throwable = null;
                Object var8_10 = null;
                InputStream current = contents;
                try {
                    ArrayList<ListenableFuture> chunkFutures = new ArrayList<ListenableFuture>();
                    int partNumber = 1;
                    while (partNumber <= 32) {
                        byte[] chunk;
                        if (partNumber < 32) {
                            chunk = this.readChunk(current);
                        } else {
                            this.composeLimitHitCounter.inc();
                            chunk = EMPTY;
                            this.log.debug("Upload for {} has hit Google Cloud Storage multipart-compose limit ({} total times limit hit)", (Object)destination, (Object)this.getNumberOfTimesComposeLimitHit());
                            String finalChunkName = this.toChunkName(destination, 32);
                            chunkNames.add(finalChunkName);
                            chunkFutures.add(this.executorService.submit(() -> {
                                this.log.debug("Uploading final chunk {} for {} of unknown remaining bytes", (Object)32, (Object)destination);
                                BlobInfo blobInfo = BlobInfo.newBuilder((String)bucket, (String)finalChunkName).build();
                                return storage.create(blobInfo, current, new Storage.BlobWriteOption[]{Storage.BlobWriteOption.disableGzipContent()});
                            }));
                        }
                        if (chunk == EMPTY && partNumber > 1) break;
                        String chunkName = this.toChunkName(destination, partNumber);
                        chunkNames.add(chunkName);
                        if (partNumber == 1) {
                            BlobInfo blobInfo = BlobInfo.newBuilder((String)bucket, (String)chunkName).build();
                            Blob blob2 = storage.create(blobInfo, chunk, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.disableGzipContent()});
                            singleChunk = Optional.of(blob2);
                        } else {
                            singleChunk = Optional.empty();
                            int chunkIndex = partNumber;
                            chunkFutures.add(this.executorService.submit(() -> {
                                this.log.debug("Uploading chunk {} for {} of {} bytes", new Object[]{chunkIndex, destination, chunk.length});
                                BlobInfo blobInfo = BlobInfo.newBuilder((String)bucket, (String)chunkName).build();
                                return storage.create(blobInfo, chunk, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.disableGzipContent()});
                            }));
                        }
                        ++partNumber;
                    }
                    blob = singleChunk.orElseGet(() -> {
                        CountDownLatch block = new CountDownLatch(1);
                        Futures.whenAllComplete((Iterable)chunkFutures).run(() -> block.countDown(), MoreExecutors.directExecutor());
                        this.log.debug("waiting for {} remaining chunks to complete", (Object)chunkFutures.size());
                        try {
                            block.await();
                        }
                        catch (InterruptedException e) {
                            this.log.error("caught InterruptedException waiting for multipart upload to complete on {}", (Object)destination);
                            throw new RuntimeException(e);
                        }
                        this.log.debug("chunk uploads completed, sending compose request");
                        Blob finalBlob = storage.compose(Storage.ComposeRequest.of((String)bucket, (Iterable)chunkNames, (String)destination));
                        this.log.debug("Parallel multipart upload of {} complete", (Object)destination);
                        return finalBlob;
                    });
                    if (current == null) break block20;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (current != null) {
                                current.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new BlobStoreException("Error uploading blob", (Throwable)e, null);
                    }
                }
                current.close();
            }
            return blob;
        }
        finally {
            this.numberOfChunks.update(chunkNames.size());
            this.deferredCleanup(storage, bucket, chunkNames);
        }
    }

    @VisibleForTesting
    Histogram numberOfChunksHistogram() {
        return this.numberOfChunks;
    }

    private void deferredCleanup(Storage storage, String bucket, List<String> chunkNames) {
        this.executorService.submit(() -> chunkNames.stream().filter(part -> part.contains(".chunk")).forEach(chunk -> {
            boolean bl = storage.delete(bucket, chunk, new Storage.BlobSourceOption[0]);
        }));
    }

    private String toChunkName(String destination, int chunkNumber) {
        if (chunkNumber == 1) {
            return destination;
        }
        return String.valueOf(destination) + ".chunk" + chunkNumber;
    }

    private byte[] readChunk(InputStream input) throws IOException {
        byte[] buffer = new byte[this.chunkSize];
        int offset = 0;
        int remain = this.chunkSize;
        int bytesRead = 0;
        while (remain > 0 && bytesRead >= 0) {
            bytesRead = input.read(buffer, offset, remain);
            if (bytesRead <= 0) continue;
            offset += bytesRead;
            remain -= bytesRead;
        }
        if (offset > 0) {
            return Arrays.copyOfRange(buffer, 0, offset);
        }
        return EMPTY;
    }
}

