/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.sonatype.nexus.blobstore.gcloud.internal.AbstractGoogleClientFactory;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudBlobStore;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Named;
import org.apache.shiro.util.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

@Named
public class GoogleCloudStorageFactory
extends AbstractGoogleClientFactory {
    Storage create(BlobStoreConfiguration configuration) throws Exception {
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setTransportOptions(this.transportOptions());
        String credentialFile = (String)configuration.attributes(GoogleCloudBlobStore.CONFIG_KEY).get("credentialFilePath", String.class);
        if (StringUtils.hasText((String)credentialFile)) {
            ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(credentialFile));
            this.logger.debug("loaded {} from {} for Google storage client", (Object)credentials, (Object)credentialFile);
            builder.setCredentials((Credentials)credentials);
            builder.setProjectId(this.getProjectId(credentialFile));
        }
        return (Storage)builder.build().getService();
    }
}

