/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.property.ImplicitSourcePropertiesFile;

public class GoogleCloudPropertiesFile
extends ImplicitSourcePropertiesFile {
    private static final Logger log = LoggerFactory.getLogger(GoogleCloudPropertiesFile.class);
    private final Bucket bucket;
    private final String key;

    public GoogleCloudPropertiesFile(Bucket bucket, String key) {
        this.bucket = (Bucket)Preconditions.checkNotNull((Object)bucket);
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws IOException {
        log.debug("Loading properties: {}", (Object)this.key);
        Blob blob = this.bucket.get(this.key, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.MEDIA_LINK})});
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ReadChannel channel = blob.reader(new Blob.BlobSourceOption[0]);
            try {
                try (InputStream inputStream = Channels.newInputStream((ReadableByteChannel)channel);){
                    this.load(inputStream);
                }
                if (channel == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (channel == null) throw throwable;
                channel.close();
                throw throwable;
            }
            channel.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void store() throws IOException {
        log.debug("Storing properties: {}", (Object)this.key);
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        this.store(bufferStream, null);
        byte[] buffer = bufferStream.toByteArray();
        this.bucket.create(this.key, buffer, new Bucket.BlobTargetOption[0]);
    }

    public boolean exists() throws IOException {
        return this.bucket.get(this.key, new Storage.BlobGetOption[0]) != null;
    }

    public void remove() throws IOException {
        Blob blob = this.bucket.get(this.key, new Storage.BlobGetOption[0]);
        if (blob != null) {
            blob.delete(new Blob.BlobSourceOption[0]);
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "key=" + this.key + '}';
    }
}

