/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.gcloud.internal.DeletedBlobIndex;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudBlobStore;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;

@Named(value="Google Cloud Blob Stores")
public class GoogleCloudBlobStoreHealthCheck
extends HealthCheck {
    private final Provider<BlobStoreManager> blobStoreManagerProvider;

    @Inject
    public GoogleCloudBlobStoreHealthCheck(Provider<BlobStoreManager> blobStoreManagerProvider) {
        this.blobStoreManagerProvider = (Provider)Preconditions.checkNotNull(blobStoreManagerProvider);
    }

    protected HealthCheck.Result check() {
        Iterable blobstoreItr = ((BlobStoreManager)this.blobStoreManagerProvider.get()).browse();
        Map<String, Long> googleBlobstores = StreamSupport.stream(blobstoreItr.spliterator(), false).filter(b -> b instanceof GoogleCloudBlobStore).collect(Collectors.toMap(blobStore -> blobStore.getBlobStoreConfiguration().getName(), blobStore -> ((GoogleCloudBlobStore)((Object)blobStore)).getSoftDeletedBlobCount()));
        ArrayList<String> violations = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : googleBlobstores.entrySet()) {
            if (entry.getValue() < (long)DeletedBlobIndex.WARN_LIMIT.intValue()) continue;
            violations.add(String.format("%s has %s soft-deleted blobs awaiting compaction", entry.getKey(), entry.getValue()));
        }
        if (violations.isEmpty()) {
            return HealthCheck.Result.healthy((String)String.format("%s Google Cloud Blob Store(s) are nominal", googleBlobstores.keySet().size()));
        }
        return HealthCheck.Result.unhealthy((String)String.format("The following Google Cloud Blob Stores would benefit from a Compact Task:<br>%s", String.join((CharSequence)"<br>", violations)));
    }
}

