/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;

@Named(value="Google Cloud Storage")
public class GoogleCloudBlobStoreDescriptor
extends BlobStoreDescriptorSupport {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final StringTextFormField bucket = new StringTextFormField("bucketName", messages.bucketName(), messages.bucketHelp(), true);
    private final StringTextFormField location = new StringTextFormField("region", messages.locationName(), messages.locationHelp(), true).withInitialValue("us-central1");
    private final StringTextFormField credentialFile = new StringTextFormField("credentialFilePath", messages.credentialPath(), messages.credentialHelp(), false);

    @Inject
    public GoogleCloudBlobStoreDescriptor(BlobStoreQuotaService quotaService) {
        super(quotaService);
    }

    public String getName() {
        return messages.name();
    }

    public String getId() {
        return "google";
    }

    public List<FormField> getFormFields() {
        return Arrays.asList(this.bucket, this.location, this.credentialFile);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Google Cloud Storage")
        public String name();

        @MessageBundle.DefaultMessage(value="Bucket")
        public String bucketName();

        @MessageBundle.DefaultMessage(value="Google Cloud Bucket Name")
        public String bucketHelp();

        @MessageBundle.DefaultMessage(value="Region")
        public String locationName();

        @MessageBundle.DefaultMessage(value="Must be a valid single region; dual-region or multi-region locations are not supported")
        public String locationHelp();

        @MessageBundle.DefaultMessage(value="Credentials")
        public String credentialPath();

        @MessageBundle.DefaultMessage(value="Absolute path to Google Application Credentials JSON file")
        public String credentialHelp();
    }
}

