/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Streams;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.blobstore.gcloud.GoogleCloudProjectException;
import com.sonatype.nexus.blobstore.gcloud.internal.DeletedBlobIndex;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleAttributesLocation;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudBlobAttributes;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudDatastoreFactory;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudPropertiesFile;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudStorageFactory;
import com.sonatype.nexus.blobstore.gcloud.internal.ShardedCounterMetricsStore;
import com.sonatype.nexus.blobstore.gcloud.internal.Uploader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.sonatype.nexus.blobstore.AttributesLocation;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.BlobStoreSupport;
import org.sonatype.nexus.blobstore.BlobSupport;
import org.sonatype.nexus.blobstore.MetricsInputStream;
import org.sonatype.nexus.blobstore.StreamMetrics;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.blobstore.api.UnimplementedRawObjectAccess;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named(value="Google Cloud Storage")
public class GoogleCloudBlobStore
extends BlobStoreSupport<GoogleAttributesLocation> {
    public static final String TYPE = "Google Cloud Storage";
    public static final String CONFIG_KEY = "Google Cloud Storage".toLowerCase();
    public static final String BUCKET_NAME_KEY = "bucketName";
    public static final String CREDENTIAL_FILE_PATH_KEY = "credentialFilePath";
    public static final String REGION_KEY = "region";
    public static final String METADATA_FILENAME = "metadata.properties";
    public static final String TYPE_KEY = "type";
    public static final String TYPE_V1 = "gcp/1";
    static final String CONTENT_PREFIX = "content";
    private static final String FILE_V1 = "file/1";
    private static final int FLUSH_FREQUENCY_IN_SECONDS = 5;
    private final RawObjectAccess rawObjectAccess = new UnimplementedRawObjectAccess();
    private final GoogleCloudStorageFactory storageFactory;
    private final Uploader uploader;
    private final int quotaCheckInterval;
    private final int deletedBlobQueryLimit;
    private final int metricsFlushDelaySeconds;
    private ShardedCounterMetricsStore metricsStore;
    private Storage storage;
    private Bucket bucket;
    private GoogleCloudDatastoreFactory datastoreFactory;
    private DeletedBlobIndex deletedBlobIndex;
    private LoadingCache<BlobId, GoogleCloudStorageBlob> liveBlobs;
    private MetricRegistry metricRegistry;
    private BlobStoreMetricsService metricsService;
    private PeriodicJobService periodicJobService;
    private BlobStoreQuotaService quotaService;
    private PeriodicJobService.PeriodicJob quotaCheckingJob;
    private PeriodicJobService.PeriodicJob flushJob;

    public GoogleCloudBlobStore(GoogleCloudStorageFactory storageFactory, BlobIdLocationResolver blobIdLocationResolver, PeriodicJobService periodicJobService, GoogleCloudDatastoreFactory datastoreFactory, DryRunPrefix dryRunPrefix, Uploader uploader, MetricRegistry metricRegistry, BlobStoreMetricsService metricsService, BlobStoreQuotaService quotaService, int quotaCheckInterval) {
        this(storageFactory, blobIdLocationResolver, periodicJobService, datastoreFactory, dryRunPrefix, uploader, metricRegistry, metricsService, quotaService, quotaCheckInterval, 100000, 1);
    }

    @Inject
    public GoogleCloudBlobStore(GoogleCloudStorageFactory storageFactory, BlobIdLocationResolver blobIdLocationResolver, PeriodicJobService periodicJobService, GoogleCloudDatastoreFactory datastoreFactory, DryRunPrefix dryRunPrefix, Uploader uploader, MetricRegistry metricRegistry, BlobStoreMetricsService metricsService, BlobStoreQuotaService quotaService, @Named(value="${nexus.blobstore.quota.warnIntervalSeconds:-60}") @Named(value="${nexus.blobstore.quota.warnIntervalSeconds:-60}") int quotaCheckInterval, @Named(value="${nexus.gcs.deletedBlobIndex.contentQueryLimit:-100000}") @Named(value="${nexus.gcs.deletedBlobIndex.contentQueryLimit:-100000}") int deletedBlobQueryLimit, @Named(value="${nexus.gcs.metricsStore.flushDelay:-1}") @Named(value="${nexus.gcs.metricsStore.flushDelay:-1}") int metricsFlushDelaySeconds) {
        super(blobIdLocationResolver, dryRunPrefix);
        this.periodicJobService = periodicJobService;
        this.storageFactory = (GoogleCloudStorageFactory)Preconditions.checkNotNull((Object)storageFactory);
        this.datastoreFactory = datastoreFactory;
        this.uploader = uploader;
        this.metricRegistry = metricRegistry;
        this.metricsService = metricsService;
        this.quotaService = quotaService;
        this.quotaCheckInterval = quotaCheckInterval;
        this.deletedBlobQueryLimit = deletedBlobQueryLimit;
        this.metricsFlushDelaySeconds = metricsFlushDelaySeconds;
    }

    protected void doStart() throws Exception {
        this.log.info("starting " + this.getBlobStoreConfiguration().getName());
        GoogleCloudPropertiesFile metadata = new GoogleCloudPropertiesFile(this.bucket, METADATA_FILENAME);
        if (metadata.exists()) {
            metadata.load();
            String type = metadata.getProperty(TYPE_KEY);
            Preconditions.checkState((TYPE_V1.equals(type) || FILE_V1.equals(type) ? 1 : 0) != 0, (String)"Unsupported blob store type/version: %s in %s", (Object)type, (Object)((Object)metadata));
        } else {
            metadata.setProperty(TYPE_KEY, TYPE_V1);
            metadata.store();
        }
        this.liveBlobs = CacheBuilder.newBuilder().weakValues().recordStats().build(CacheLoader.from(arg_0 -> GoogleCloudStorageBlob.new(this, arg_0)));
        this.wrapWithGauge("liveBlobsCache.size", () -> this.liveBlobs.size());
        this.wrapWithGauge("liveBlobsCache.hitCount", () -> this.liveBlobs.stats().hitCount());
        this.wrapWithGauge("liveBlobsCache.missCount", () -> this.liveBlobs.stats().missCount());
        this.wrapWithGauge("liveBlobsCache.totalLoadTime", () -> this.liveBlobs.stats().totalLoadTime());
        this.wrapWithGauge("liveBlobsCache.evictionCount", () -> this.liveBlobs.stats().evictionCount());
        this.wrapWithGauge("liveBlobsCache.requestCount", () -> this.liveBlobs.stats().requestCount());
        this.log.debug("liveBlobs cache initialized for " + this.getBlobStoreConfiguration().getName());
        this.initializeMetadataStores();
        this.log.debug("deleted blobs index and metrics store initialized for " + this.getBlobStoreConfiguration().getName());
        this.periodicJobService.startUsing();
        this.quotaCheckingJob = this.periodicJobService.schedule(BlobStoreQuotaSupport.createQuotaCheckJob((BlobStore)this, (BlobStoreQuotaService)this.quotaService, (Logger)this.log), this.quotaCheckInterval);
        this.flushJob = this.periodicJobService.schedule(() -> this.metricsStore.flush(), 5);
        this.log.debug("internal quota and metrics flush jobs started for " + this.getBlobStoreConfiguration().getName());
        this.log.info(String.valueOf(this.getBlobStoreConfiguration().getName()) + " started");
    }

    protected void doStop() throws Exception {
        this.log.info("stopping " + this.getBlobStoreConfiguration().getName());
        this.liveBlobs = null;
        this.quotaCheckingJob.cancel();
        this.flushJob.cancel();
        this.periodicJobService.stopUsing();
        this.log.debug("internal quota and metrics flush jobs stopped for " + this.getBlobStoreConfiguration().getName() + ", flushing metrics");
        this.metricsStore.flush();
        this.log.info(String.valueOf(this.getBlobStoreConfiguration().getName()) + " stopped");
    }

    protected void wrapWithGauge(String nameSuffix, Supplier<?> valueSupplier) {
        this.metricRegistry.gauge(String.format("%s@%s.%s", GoogleCloudBlobStore.class.getName(), this.getBlobStoreConfiguration().getName(), nameSuffix), () -> ((Supplier)valueSupplier)::get);
    }

    protected Blob doCreate(InputStream blobData, Map<String, String> headers, @Nullable BlobId blobId) {
        return this.createInternal(headers, destination -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream data = blobData;){
                MetricsInputStream input = new MetricsInputStream(data);
                this.uploader.upload(this.storage, this.getConfiguredBucketName(), destination, (InputStream)input);
                return input.getMetrics();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, blobId);
    }

    @Guarded(by={"STARTED"})
    public Blob create(Path path, Map<String, String> map, long size, HashCode hash) {
        throw new BlobStoreException("hard links not supported", null);
    }

    @Guarded(by={"STARTED"})
    public Blob copy(BlobId blobId, Map<String, String> headers) {
        GoogleCloudStorageBlob sourceBlob = (GoogleCloudStorageBlob)((Object)Preconditions.checkNotNull((Object)this.get(blobId)));
        return this.createInternal(headers, destination -> {
            sourceBlob.getBlob().copyTo(this.getConfiguredBucketName(), destination, new Blob.BlobSourceOption[0]);
            BlobMetrics metrics = sourceBlob.getMetrics();
            return new StreamMetrics(metrics.getContentSize(), metrics.getSha1Hash());
        }, null);
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public Blob get(BlobId blobId) {
        return this.get(blobId, false);
    }

    @Nullable
    @Guarded(by={"STARTED"})
    @Timed
    public Blob get(BlobId blobId, boolean includeDeleted) {
        GoogleCloudStorageBlob blob;
        block10: {
            Preconditions.checkNotNull((Object)blobId);
            blob = (GoogleCloudStorageBlob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
            if (blob.isStale()) {
                Lock lock = blob.lock();
                try {
                    if (!blob.isStale()) break block10;
                    GoogleCloudBlobAttributes blobAttributes = new GoogleCloudBlobAttributes(this.bucket, this.attributePath(blobId));
                    boolean loaded = blobAttributes.load();
                    if (!loaded) {
                        this.log.warn("Attempt to access non-existent blob {} ({})", (Object)blobId, (Object)blobAttributes);
                        return null;
                    }
                    if (blobAttributes.isDeleted() && !includeDeleted) {
                        this.log.warn("Attempt to access soft-deleted blob {} ({})", (Object)blobId, (Object)blobAttributes);
                        return null;
                    }
                    try {
                        blob.refresh(blobAttributes.getHeaders(), blobAttributes.getMetrics());
                    }
                    catch (IOException e) {
                        throw new BlobStoreException((Throwable)e, blobId);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        this.log.debug("Accessing blob {}", (Object)blobId);
        return blob;
    }

    protected boolean doDelete(BlobId blobId, String reason) {
        GoogleCloudStorageBlob blob = (GoogleCloudStorageBlob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        Lock lock = blob.lock();
        try {
            this.log.debug("Soft deleting blob {}", (Object)blobId);
            GoogleCloudBlobAttributes blobAttributes = new GoogleCloudBlobAttributes(this.bucket, this.attributePath(blobId));
            boolean loaded = blobAttributes.load();
            if (!loaded) {
                this.log.warn("Attempt to mark-for-delete non-existent blob {}", (Object)blobId);
                return false;
            }
            if (blobAttributes.isDeleted()) {
                this.log.debug("Attempt to delete already-deleted blob {}", (Object)blobId);
                return false;
            }
            blobAttributes.setDeleted(true);
            blobAttributes.setDeletedReason(reason);
            blobAttributes.store();
            this.deletedBlobIndex.add(blobId);
            blob.markStale();
            return true;
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean doDeleteHard(BlobId blobId) {
        try {
            this.log.debug("Hard deleting blob {}", (Object)blobId);
            boolean blobDeleted = this.storage.delete(this.getConfiguredBucketName(), this.contentPath(blobId), new Storage.BlobSourceOption[0]);
            if (blobDeleted) {
                String attributePath = this.attributePath(blobId);
                BlobAttributes attributes = this.getBlobAttributes(blobId);
                this.metricsStore.recordDeletion(blobId, attributes.getMetrics().getContentSize());
                this.storage.delete(this.getConfiguredBucketName(), attributePath, new Storage.BlobSourceOption[0]);
                this.deletedBlobIndex.remove(blobId);
            }
            boolean bl = blobDeleted;
            return bl;
        }
        finally {
            this.liveBlobs.invalidate((Object)blobId);
        }
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetrics getMetrics() {
        return this.metricsStore.getMetrics();
    }

    @Guarded(by={"STARTED"})
    public void doCompact(@Nullable BlobStoreUsageChecker blobStoreUsageChecker) {
        this.log.info("Begin deleted blobs processing");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
            AtomicInteger counter = new AtomicInteger(0);
            this.deletedBlobIndex.getContents().forEach(blobId -> {
                CancelableHelper.checkCancellation();
                this.deleteHard((BlobId)blobId);
                counter.incrementAndGet();
                progressLogger.info("Elapsed time: {}, processed: {}", new Object[]{progressLogger.getElapsed(), counter.get()});
            });
            progressLogger.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public BlobStoreConfiguration getBlobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    protected BlobAttributes getBlobAttributes(GoogleAttributesLocation attributesFilePath) throws IOException {
        GoogleCloudBlobAttributes googleCloudBlobAttributes = new GoogleCloudBlobAttributes(this.bucket, attributesFilePath.getFullPath());
        googleCloudBlobAttributes.load();
        return googleCloudBlobAttributes;
    }

    protected void doInit(BlobStoreConfiguration configuration) {
        this.migrateLegacyConfiguration(configuration);
        try {
            this.storage = this.storageFactory.create(configuration);
            String location = (String)configuration.attributes(CONFIG_KEY).get(REGION_KEY, String.class);
            this.bucket = this.getOrCreateStorageBucket(location);
        }
        catch (Exception e) {
            throw new GoogleCloudProjectException("Unable to initialize blob store bucket: " + this.getConfiguredBucketName(), e);
        }
        this.initializeMetadataStores();
    }

    private void migrateLegacyConfiguration(BlobStoreConfiguration configuration) {
        NestedAttributesMap config = configuration.attributes(CONFIG_KEY);
        if (config.contains("bucket")) {
            this.log.debug("detected legacy bucket configuration key for {}, attempting migration", (Object)configuration);
            config.set(BUCKET_NAME_KEY, config.get("bucket"));
            config.remove("bucket");
            this.log.debug("bucket->bucketName configuration migration complete for {}", (Object)configuration);
        }
        if (config.contains("location")) {
            this.log.debug("detected legacy location configuration key for {}, attempting migration", (Object)configuration);
            config.set(REGION_KEY, config.get("location"));
            config.remove("location");
            this.log.debug("location->region configuration migration complete for {}", (Object)configuration);
        }
        if (config.contains("credential_file")) {
            this.log.debug("detected legacy credential_file configuration key for {}, attempting migration", (Object)configuration);
            config.set(CREDENTIAL_FILE_PATH_KEY, config.get("credential_file"));
            config.remove("credential_file");
            this.log.debug("credential_file->credentialFilePath configuration migration complete for {}", (Object)configuration);
        }
    }

    protected void initializeMetadataStores() {
        try {
            if (this.deletedBlobIndex == null) {
                this.deletedBlobIndex = new DeletedBlobIndex(this.datastoreFactory, this.blobStoreConfiguration, this.deletedBlobQueryLimit);
                this.deletedBlobIndex.initialize();
            }
        }
        catch (Exception e) {
            throw new GoogleCloudProjectException("Failed to create deleted blob index", e);
        }
        try {
            if (this.metricsStore == null) {
                this.metricsStore = new ShardedCounterMetricsStore(this.blobIdLocationResolver, this.datastoreFactory, this.blobStoreConfiguration, this.metricsFlushDelaySeconds);
                this.metricsStore.initialize();
            }
        }
        catch (Exception e) {
            throw new GoogleCloudProjectException("Failed to create blob metrics store", e);
        }
    }

    protected Bucket getOrCreateStorageBucket(String location) {
        Bucket bucket = this.storage.get(this.getConfiguredBucketName(), new Storage.BucketGetOption[0]);
        if (bucket == null) {
            bucket = this.storage.create(BucketInfo.newBuilder((String)this.getConfiguredBucketName()).setLocation(location).setStorageClass(StorageClass.REGIONAL).build(), new Storage.BucketTargetOption[0]);
        }
        return bucket;
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetricsService getMetricsService() {
        return this.metricsService;
    }

    @Guarded(by={"NEW", "STOPPED", "FAILED", "SHUTDOWN"})
    public void remove() {
        this.metricsStore.removeData();
        this.deletedBlobIndex.removeData();
    }

    @Guarded(by={"STARTED"})
    public Stream<BlobId> getBlobIdStream() {
        return this.getBlobIdStream(CONTENT_PREFIX);
    }

    @Guarded(by={"STARTED"})
    public Stream<BlobId> getDirectPathBlobIdStream(String prefix) {
        String subpath = String.format("%s/%s/%s", CONTENT_PREFIX, "directpath", prefix);
        return this.getBlobIdStream(subpath);
    }

    private Stream<BlobId> getBlobIdStream(String subpath) {
        return this.blobStream(subpath).filter(blob -> blob.getName().endsWith(".properties")).map(GoogleAttributesLocation::new).map(this::getBlobIdFromAttributeFilePath).map(BlobId::new);
    }

    Stream<BlobInfo> blobStream(String path) {
        return Streams.stream((Iterable)this.bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path)}).iterateAll()).map(c -> c);
    }

    Stream<BlobInfo> nonTempBlobPropertiesFileStream(Stream<BlobInfo> stream) {
        return stream.filter(o -> o.getBlobId().getName().endsWith(".properties")).filter(o -> !o.getBlobId().getName().contains("/content/tmp/"));
    }

    protected String getBlobIdFromAttributeFilePath(GoogleAttributesLocation attributesLocation) {
        if (attributesLocation.getFileName().startsWith("tmp$")) {
            String name = attributesLocation.getFileName();
            return StringUtils.removeEnd((String)name.substring(name.lastIndexOf(47) + 1), (String)".properties");
        }
        return super.getBlobIdFromAttributeFilePath((AttributesLocation)attributesLocation);
    }

    @Guarded(by={"STARTED"})
    public BlobAttributes getBlobAttributes(BlobId blobId) {
        try {
            GoogleCloudBlobAttributes blobAttributes = new GoogleCloudBlobAttributes(this.bucket, this.attributePath(blobId));
            return blobAttributes.load() ? blobAttributes : null;
        }
        catch (IOException e) {
            this.log.error("Unable to load GoogleCloudBlobAttributes for blob id: {}", (Object)blobId, (Object)e);
            throw new BlobStoreException((Throwable)e, blobId);
        }
    }

    @Guarded(by={"STARTED"})
    public void setBlobAttributes(BlobId blobId, BlobAttributes blobAttributes) {
        GoogleCloudBlobAttributes existing = (GoogleCloudBlobAttributes)this.getBlobAttributes(blobId);
        if (existing != null) {
            try {
                existing.updateFrom(blobAttributes);
                existing.store();
            }
            catch (IOException e) {
                this.log.error("Unable to set GoogleCloudBlobAttributes for blob id: {}", (Object)blobId, (Object)e);
            }
        }
    }

    @Guarded(by={"STARTED"})
    public boolean exists(BlobId blobId) {
        Preconditions.checkNotNull((Object)blobId);
        return this.getBlobAttributes(blobId) != null;
    }

    public boolean isStorageAvailable() {
        return true;
    }

    protected String attributePathString(BlobId blobId) {
        return this.attributePath(blobId);
    }

    @Guarded(by={"STARTED"})
    public boolean isWritable() {
        try {
            List results = this.storage.testIamPermissions(this.getConfiguredBucketName(), Arrays.asList("storage.objects.create", "storage.objects.delete"), new Storage.BucketSourceOption[0]);
            return !results.contains(false);
        }
        catch (StorageException e) {
            throw new BlobStoreException("failed to retrive User ACL for " + this.getConfiguredBucketName(), (Throwable)e, null);
        }
    }

    public RawObjectAccess getRawObjectAccess() {
        return this.rawObjectAccess;
    }

    public Stream<BlobId> getBlobIdUpdatedSinceStream(int sinceDays) {
        if (sinceDays < 0) {
            throw new IllegalArgumentException("sinceDays must >= 0");
        }
        OffsetDateTime offsetDateTime = Instant.now().minus(sinceDays, ChronoUnit.DAYS).atOffset(ZoneOffset.UTC);
        return this.getBlobIdUpdatedSinceStream(offsetDateTime);
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsByType() {
        return this.metricsStore.getOperationMetricsByType();
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return Collections.emptyMap();
    }

    public void clearOperationMetrics() {
    }

    @VisibleForTesting
    Stream<BlobId> getBlobIdUpdatedSinceStream(OffsetDateTime offsetDateTime) {
        return this.nonTempBlobPropertiesFileStream(this.blobStream(CONTENT_PREFIX)).filter(blobInfo -> blobInfo.getUpdateTimeOffsetDateTime().isAfter(offsetDateTime)).map(GoogleAttributesLocation::new).map(this::getBlobIdFromAttributeFilePath).map(BlobId::new);
    }

    Blob createInternal(Map<String, String> headers, BlobIngester ingester, @Nullable BlobId assignedBlobId) {
        Preconditions.checkNotNull(headers);
        Preconditions.checkArgument((boolean)headers.containsKey("BlobStore.blob-name"), (String)"Missing header: %s", (Object)"BlobStore.blob-name");
        Preconditions.checkArgument((boolean)headers.containsKey("BlobStore.created-by"), (String)"Missing header: %s", (Object)"BlobStore.created-by");
        BlobId blobId = this.getBlobId(headers, assignedBlobId);
        String blobPath = this.contentPath(blobId);
        String attributePath = this.attributePath(blobId);
        GoogleCloudStorageBlob blob = (GoogleCloudStorageBlob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        Lock lock = blob.lock();
        try {
            this.log.debug("Writing blob {} to {}", (Object)blobId, (Object)blobPath);
            StreamMetrics streamMetrics = ingester.ingestTo(blobPath);
            BlobMetrics metrics = new BlobMetrics(new DateTime(), streamMetrics.getSha1(), streamMetrics.getSize());
            blob.refresh(headers, metrics);
            GoogleCloudBlobAttributes blobAttributes = new GoogleCloudBlobAttributes(this.bucket, attributePath, headers, metrics);
            blobAttributes.store();
            this.metricsStore.recordAddition(blobId, metrics.getContentSize());
            GoogleCloudStorageBlob googleCloudStorageBlob = blob;
            return googleCloudStorageBlob;
        }
        catch (IOException e) {
            this.deleteNonExplosively(attributePath);
            this.deleteNonExplosively(blobPath);
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    long getSoftDeletedBlobCount() {
        return this.deletedBlobIndex.getContents().count();
    }

    @VisibleForTesting
    DeletedBlobIndex getDeletedBlobIndex() {
        return this.deletedBlobIndex;
    }

    @VisibleForTesting
    void flushMetricsStore() {
        this.metricsStore.flush();
    }

    @VisibleForTesting
    ShardedCounterMetricsStore getMetricsStore() {
        return this.metricsStore;
    }

    private void deleteNonExplosively(String contentPath) {
        try {
            this.storage.delete(this.getConfiguredBucketName(), contentPath, new Storage.BlobSourceOption[0]);
        }
        catch (Exception e) {
            this.log.warn("caught exception attempting to delete during cleanup", (Throwable)e);
        }
    }

    private String contentPath(BlobId id) {
        return String.valueOf(this.getLocation(id)) + ".bytes";
    }

    private String attributePath(BlobId id) {
        return String.valueOf(this.getLocation(id)) + ".properties";
    }

    private String getLocation(BlobId id) {
        return "content/" + this.blobIdLocationResolver.getLocation(id);
    }

    private String getConfiguredBucketName() {
        return this.blobStoreConfiguration.attributes(CONFIG_KEY).require(BUCKET_NAME_KEY).toString();
    }

    private static interface BlobIngester {
        public StreamMetrics ingestTo(String var1) throws IOException;
    }

    class GoogleCloudStorageBlob
    extends BlobSupport {
        GoogleCloudStorageBlob(BlobId blobId) {
            super(blobId);
        }

        public InputStream doGetInputStream() {
            com.google.cloud.storage.Blob blob = this.getBlob();
            ReadChannel channel = blob.reader(new Blob.BlobSourceOption[0]);
            return Channels.newInputStream((ReadableByteChannel)channel);
        }

        com.google.cloud.storage.Blob getBlob() {
            return GoogleCloudBlobStore.this.bucket.get(GoogleCloudBlobStore.this.contentPath(this.getId()), new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.MEDIA_LINK})});
        }
    }
}

