/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.common.collect.Lists;
import com.sonatype.nexus.blobstore.gcloud.GoogleCloudProjectException;
import com.sonatype.nexus.blobstore.gcloud.internal.DatastoreKeyHierarchy;
import com.sonatype.nexus.blobstore.gcloud.internal.GoogleCloudDatastoreFactory;
import com.sonatype.nexus.blobstore.gcloud.internal.Namespace;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

class DeletedBlobIndex
extends ComponentSupport {
    private Datastore gcsDatastore;
    private KeyFactory deletedBlobsKeyFactory;
    private final String namespace;
    private static final String DELETED_BLOBS = "DeletedBlobs";
    static final Integer WARN_LIMIT = 1000;
    static final int DEFAULT_CONTENT_QUERY_LIMIT = 100000;
    private final int contentQueryLimit;

    DeletedBlobIndex(GoogleCloudDatastoreFactory factory, BlobStoreConfiguration blobStoreConfiguration) throws Exception {
        this(factory, blobStoreConfiguration, 100000);
    }

    DeletedBlobIndex(GoogleCloudDatastoreFactory factory, BlobStoreConfiguration blobStoreConfiguration, int contentQueryLimit) throws Exception {
        this.gcsDatastore = factory.create(blobStoreConfiguration);
        this.namespace = "blobstore-" + Namespace.safe(blobStoreConfiguration.getName());
        this.deletedBlobsKeyFactory = (KeyFactory)((KeyFactory)((KeyFactory)this.gcsDatastore.newKeyFactory().addAncestors(DatastoreKeyHierarchy.NXRM_ROOT, new PathElement[0])).setNamespace(this.namespace)).setKind(DELETED_BLOBS);
        this.contentQueryLimit = contentQueryLimit;
    }

    int getContentQueryLimit() {
        return this.contentQueryLimit;
    }

    void initialize() {
        try {
            this.test();
        }
        catch (DatastoreException e) {
            throw new GoogleCloudProjectException("unable to write deleted blob metadata", e);
        }
    }

    void test() {
        BlobId sentinel = new BlobId("tmp$/sentinel");
        this.add(sentinel);
        this.remove(sentinel);
    }

    void add(BlobId blobId) {
        Key key = this.deletedBlobsKeyFactory.newKey(blobId.asUniqueString());
        Entity entity = Entity.newBuilder((Key)key).build();
        this.gcsDatastore.put((FullEntity)entity);
    }

    void remove(BlobId blobId) {
        this.gcsDatastore.delete(new Key[]{this.deletedBlobsKeyFactory.newKey(blobId.asUniqueString())});
    }

    void removeData() {
        this.log.warn("removing all entries in the index of soft-deleted blobs...");
        KeyQuery query = ((KeyQuery.Builder)((KeyQuery.Builder)Query.newKeyQueryBuilder().setNamespace(this.namespace)).setKind(DELETED_BLOBS)).build();
        QueryResults results = this.gcsDatastore.run((Query)query);
        List keys = StreamSupport.stream(Spliterators.spliteratorUnknownSize(results, 16), false).collect(Collectors.toList());
        List partitions = Lists.partition(keys, (int)500);
        this.log.warn("keys has length of {}, split into {} partitions of 500", (Object)keys.size(), (Object)partitions.size());
        IntStream.range(0, partitions.size()).forEach(idx -> {
            List partition = (List)partitions.get(idx);
            this.gcsDatastore.delete(partition.toArray(new Key[partition.size()]));
            this.log.debug("deleted partition " + idx);
        });
        this.log.warn("deleted {} blobIds from the soft-deleted blob index", (Object)keys.size());
    }

    Stream<BlobId> getContents() {
        KeyQuery query = ((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)Query.newKeyQueryBuilder().setKind(DELETED_BLOBS)).setNamespace(this.namespace)).setLimit(Integer.valueOf(this.contentQueryLimit))).build();
        QueryResults results = this.gcsDatastore.run((Query)query);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(results, 16), false).map(key -> new BlobId(key.getName()));
    }
}

