/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.gcloud.internal;

import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.ProxySelector;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoogleClientFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final long KEEP_ALIVE_DURATION = 60000L;

    TransportOptions transportOptions() {
        return HttpTransportOptions.newBuilder().setHttpTransportFactory(() -> new ApacheHttpTransport(this.newHttpClient())).build();
    }

    HttpClient newHttpClient() {
        return this.newDefaultHttpClient(SSLSocketFactory.getSocketFactory(), this.newDefaultHttpParams(), ProxySelector.getDefault());
    }

    HttpParams newDefaultHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)200);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(200));
        return params;
    }

    DefaultHttpClient newDefaultHttpClient(SSLSocketFactory socketFactory, HttpParams params, ProxySelector proxySelector) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)socketFactory, 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(params, registry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, params);
        defaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, true));
        if (proxySelector != null) {
            defaultHttpClient.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(registry, proxySelector));
        }
        defaultHttpClient.setKeepAliveStrategy((response, context) -> 60000L);
        return defaultHttpClient;
    }

    String getProjectId(String credentialFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(credentialFile);){
            JsonObject credentialJsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
            return credentialJsonObject.get("project_id").getAsString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

