/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.sonatype.nexus.siesta.internal.resteasy.ComponentContainerImpl;

public class SiestaResourceMethodFinder {
    private ComponentContainerImpl componentContainer;
    private ResteasyDeployment deployment;

    public SiestaResourceMethodFinder(ComponentContainerImpl componentContainer, ResteasyDeployment deployment) {
        this.componentContainer = Objects.requireNonNull(componentContainer);
        this.deployment = Objects.requireNonNull(deployment);
    }

    public String getResourceMethodPath(HttpServletRequest request, HttpServletResponse response) {
        Path methodPath;
        StringBuilder buffer = new StringBuilder();
        ResourceMethodInvoker method = this.getResourceMethod(request, response);
        Path classPath = method.getResourceClass().getAnnotation(Path.class);
        if (Objects.nonNull(classPath)) {
            buffer.append(this.maybePrependWithForwardSlash(classPath.value()));
        }
        if (Objects.nonNull(methodPath = method.getMethod().getDeclaredAnnotation(Path.class))) {
            buffer.append(this.maybePrependWithForwardSlash(methodPath.value()));
        }
        return this.cleanForwardSlashes(buffer.toString());
    }

    public ResourceMethodInvoker getResourceMethod(HttpServletRequest request, HttpServletResponse response) {
        HttpServletInputMessage httpRequest = new HttpServletInputMessage(request, response, request.getServletContext(), null, ServletUtil.extractHttpHeaders((HttpServletRequest)request), ServletUtil.extractUriInfo((HttpServletRequest)request, (String)"/service/rest"), request.getMethod(), (SynchronousDispatcher)this.componentContainer.getDispatcher());
        return (ResourceMethodInvoker)this.deployment.getRegistry().getResourceInvoker((HttpRequest)httpRequest);
    }

    private String maybePrependWithForwardSlash(String value) {
        return value.startsWith("/") ? value : "/" + value;
    }

    private String cleanForwardSlashes(String s) {
        return s.replaceAll("//", "/");
    }
}

