/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.transport;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.BasicAuthHelper;
import org.sonatype.ossindex.service.client.transport.ProxyConfiguration;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public class HttpUrlConnectionTransport
implements Transport {
    private static final Logger log = LoggerFactory.getLogger(HttpUrlConnectionTransport.class);
    private final UserAgentSupplier userAgent;
    private OssindexClientConfiguration configuration;

    public HttpUrlConnectionTransport(UserAgentSupplier userAgent) {
        this.userAgent = (UserAgentSupplier)Preconditions.checkNotNull((Object)userAgent);
    }

    @Override
    public void init(OssindexClientConfiguration configuration) {
        this.configuration = (OssindexClientConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String post(URI url, String payloadType, String payload, String acceptType) throws Transport.TransportException, IOException {
        log.debug("POST {}; payload: {} ({}); accept: {}", new Object[]{url, payload, payloadType, acceptType});
        HttpURLConnection connection = this.connect(url.toURL());
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", payloadType);
        connection.setRequestProperty("Accept", acceptType);
        log.debug("Connecting to: {}", (Object)url);
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));){
            writer.write(payload);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        connection.connect();
        int status = connection.getResponseCode();
        log.trace("Status: {}", (Object)status);
        if (status == 200) {
            throwable2 = null;
            Object var8_12 = null;
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                StringWriter buff = new StringWriter();
                CharStreams.copy((Readable)reader, (Appendable)buff);
                return buff.toString();
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        throw new Transport.TransportException("Unexpected response; status: " + status);
    }

    protected HttpURLConnection connect(URL url) throws IOException {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkState((this.configuration != null ? 1 : 0) != 0, (Object)"Not initialized");
        HttpURLConnection connection = null;
        try {
            Proxy proxy = this.maybeCreateProxy(this.configuration);
            connection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", this.userAgent.get());
            String authorization = BasicAuthHelper.authorizationHeader(this.configuration.getAuthConfiguration());
            if (authorization != null) {
                connection.setRequestProperty("Authorization", authorization);
            }
        }
        catch (IOException e) {
            if (connection != null) {
                connection.disconnect();
            }
            throw new IOException("Failed to create connection", e);
        }
        return connection;
    }

    @Nullable
    protected Proxy maybeCreateProxy(OssindexClientConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        ProxyConfiguration proxyConfiguration = configuration.getProxyConfiguration();
        if (proxyConfiguration == null) {
            return null;
        }
        final String proxyHost = proxyConfiguration.getHost();
        InetSocketAddress address = new InetSocketAddress(proxyHost, proxyConfiguration.getPort());
        AuthConfiguration auth = proxyConfiguration.getAuthConfiguration();
        if (auth != null) {
            final PasswordAuthentication credentials = new PasswordAuthentication(auth.getUsername(), auth.getPassword().toCharArray());
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (proxyHost.equals(this.getRequestingHost()) || this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                        return credentials;
                    }
                    return super.getPasswordAuthentication();
                }
            };
            Authenticator.setDefault(authenticator);
            log.debug("Configured http-proxy authentication");
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
        log.debug("Configured http-proxy: {}", (Object)proxy);
        return proxy;
    }
}

