/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.api.componentreport.ComponentReport;
import org.sonatype.ossindex.service.client.cache.Cache;
import org.sonatype.ossindex.service.client.cache.CacheConfiguration;

public class MemoryCache
implements Cache {
    private final CacheBuilderSpec spec;
    private final com.google.common.cache.Cache<PackageUrl, ComponentReport> storage;
    private boolean closed;

    public MemoryCache(Configuration config) {
        Preconditions.checkNotNull((Object)config);
        this.spec = (CacheBuilderSpec)Preconditions.checkNotNull((Object)config.getSpec(), (Object)"Missing required cache spec");
        this.storage = CacheBuilder.from((CacheBuilderSpec)this.spec).build();
    }

    private void ensureNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Closed");
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.storage.cleanUp();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("spec", (Object)this.spec).toString();
    }

    @Override
    @Nullable
    public ComponentReport getIfPresent(PackageUrl coordinates) {
        Preconditions.checkNotNull((Object)coordinates);
        this.ensureNotClosed();
        return (ComponentReport)this.storage.getIfPresent((Object)coordinates);
    }

    @Override
    public void putAll(Map<PackageUrl, ComponentReport> reports) {
        Preconditions.checkNotNull(reports);
        this.ensureNotClosed();
        this.storage.putAll(reports);
    }

    public static class Configuration
    implements CacheConfiguration {
        public static final CacheBuilderSpec DEFAULT_SPEC = CacheBuilderSpec.parse((String)"maximumSize=256,expireAfterAccess=2m,softValues");
        private CacheBuilderSpec spec = DEFAULT_SPEC;

        public CacheBuilderSpec getSpec() {
            return this.spec;
        }

        public void setSpec(CacheBuilderSpec spec) {
            this.spec = spec;
        }

        @Override
        public Cache create() throws Exception {
            return new MemoryCache(this);
        }
    }
}

