/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.proxy;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.proxy.ProxyCacheHitEvent;
import org.sonatype.nexus.repository.proxy.ProxyRequestEvent;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class PullReplicationAnalytics
extends ComponentSupport
implements AnalyticsMarker,
EventAware {
    public static final String REMOTE_UNAVAILABLE = "Remote-Unavailable";
    public static final String CLIENT_REQUEST_COUNT = "total_client_requests";
    public static final String PREEMPTIVE_REQUEST_COUNT = "total_preemptive_requests";
    public static final String CLIENT_CACHE_HIT_COUNT = "cache_hit_count";
    public static final String PERCENT_CLIENT_CACHE_HITS = "percent_client_cache_hits";
    private final Map<String, Integer> replicationErrorCount = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Map<String, Integer>> requestCount = new ConcurrentHashMap<String, Map<String, Integer>>();

    @CachedGauge(name="nexus.analytics.proxy_metrics_by_format", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> getMetricsByFormat() {
        return this.requestCount.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            HashMap transformed = new HashMap();
            Map source = (Map)e.getValue();
            source.forEach((key, value) -> {
                if (key.equals(CLIENT_CACHE_HIT_COUNT)) {
                    double hitPercentage = ((Integer)source.get(CLIENT_CACHE_HIT_COUNT)).doubleValue() / ((Integer)source.get(CLIENT_REQUEST_COUNT)).doubleValue() * 100.0;
                    transformed.put(PERCENT_CLIENT_CACHE_HITS, (double)Math.round(hitPercentage * 100.0) / 100.0);
                } else {
                    transformed.put(key, value);
                }
            });
            return transformed;
        })).entrySet().stream().map(e -> this.toFormatMetricsMap((String)e.getKey(), (Map)e.getValue())).collect(Collectors.toList());
    }

    private Map<String, Object> toFormatMetricsMap(String format, Map<String, Number> metrics) {
        return ImmutableMap.of((Object)"format", (Object)format, (Object)"metrics", metrics);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ProxyRequestEvent proxyRequestEvent) {
        String format = proxyRequestEvent.getFormat();
        this.log.trace("onProxyRequestEvent: {}, repl: {}", (Object)format, (Object)proxyRequestEvent.isReplication());
        if (proxyRequestEvent.isReplication()) {
            this.incrementCount(format, PREEMPTIVE_REQUEST_COUNT);
        } else {
            this.incrementCount(format, CLIENT_REQUEST_COUNT);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ProxyCacheHitEvent proxyCacheHitEvent) {
        this.log.trace("onProxyCacheHit: {}, repl: {}", (Object)proxyCacheHitEvent.getFormat(), (Object)proxyCacheHitEvent.isReplication());
        if (!proxyCacheHitEvent.isReplication()) {
            this.incrementCount(proxyCacheHitEvent.getFormat(), CLIENT_CACHE_HIT_COUNT);
        }
    }

    private void incrementCount(String format, String countType) {
        this.requestCount.computeIfAbsent(format, f -> new ConcurrentHashMap()).merge(countType, 1, Integer::sum);
    }

    @CachedGauge(name="nexus.analytics.replication_proxy_error_counts", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> getErrorCount() {
        return this.replicationErrorCount.entrySet().stream().map(e -> this.toErrorCountMap((String)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList());
    }

    private Map<String, Object> toErrorCountMap(String errorCode, Integer count) {
        return ImmutableMap.of((Object)"error_code", (Object)errorCode, (Object)"count", (Object)count);
    }

    public void incrementErrorCount(int errorCode) {
        if (errorCode >= 400) {
            this.incrementErrorCount(String.valueOf(errorCode));
        }
    }

    public void incrementErrorCount(String errorCode) {
        this.replicationErrorCount.merge(errorCode, 1, Integer::sum);
    }

    @Override
    public void reset() {
        this.log.trace("Analytics Reset");
        this.replicationErrorCount.clear();
        this.requestCount.clear();
    }
}

