/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.limits;

import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.limits.ContentUtilization;
import com.sonatype.analytics.limits.LimitEntry;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ContentUsageLimits {
    public static final String TOTAL_COMPONENT = "totalComponent";
    public static final String UNIQUE_LOGINS = "uniqueLogins";
    public static final String REQUESTS_PER_MINUTE = "requestsPerMinute";
    public static final String REQUESTS_PER_DAY = "requestsPerDay";
    public static final Map<ContentUtilization, Map<String, Long>> USAGE_LIMITS = ImmutableMap.of((Object)((Object)ContentUtilization.SOFT_THRESHOLD), (Object)ImmutableMap.of((Object)"totalComponent", (Object)100000L, (Object)"uniqueLogins", (Object)100L, (Object)"requestsPerDay", (Object)20000L), (Object)((Object)ContentUtilization.STARTER_THRESHOLD), (Object)ImmutableMap.of((Object)"totalComponent", (Object)120000L, (Object)"requestsPerDay", (Object)200000L));

    private ContentUsageLimits() {
    }

    public static ContentUtilization getContentUtilization(String limitTypeParam, long metricValue) {
        ContentUtilization result = ContentUtilization.FREE_TIER;
        long currentLimitValue = 0L;
        for (Map.Entry<ContentUtilization, Map<String, Long>> entry : USAGE_LIMITS.entrySet()) {
            ContentUtilization contentUtilization = entry.getKey();
            for (Map.Entry<String, Long> limit : entry.getValue().entrySet()) {
                String limitType = limit.getKey();
                Long value = limit.getValue();
                if (!limitType.equals(limitTypeParam) || value == null || metricValue < value || value <= currentLimitValue) continue;
                result = contentUtilization;
                currentLimitValue = value;
            }
        }
        return result;
    }

    public static List<LimitEntry> getLimitsForMetric(String metricName) {
        return USAGE_LIMITS.entrySet().stream().map(entry -> {
            ContentUtilization limitName = (ContentUtilization)((Object)((Object)entry.getKey()));
            Long limitValue = (Long)((Map)entry.getValue()).get(metricName);
            if (limitValue != null) {
                return new LimitEntry(limitName.name(), limitValue);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Long getTotalComponentStarterHardLimit() {
        return USAGE_LIMITS.get((Object)ContentUtilization.STARTER_THRESHOLD).get(TOTAL_COMPONENT);
    }

    public static Long getRequestsPerDayStarterHardLimit() {
        return USAGE_LIMITS.get((Object)ContentUtilization.STARTER_THRESHOLD).get(REQUESTS_PER_DAY);
    }
}

