/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system.cpu;

import com.sonatype.analytics.internal.system.cpu.CpuInfo;
import com.sonatype.analytics.internal.system.cpu.LinuxCpuInfo;
import com.sonatype.analytics.internal.system.cpu.MacCpuInfo;
import com.sonatype.analytics.internal.system.cpu.OtherCpuInfo;
import com.sonatype.analytics.internal.system.cpu.WindowsCpuInfo;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Named
@Singleton
public class CpuInfoProvider
implements Provider<CpuInfo> {
    public CpuInfo get() {
        switch (CpuInfoProvider.determineOsType()) {
            case LINUX: {
                return new LinuxCpuInfo();
            }
            case MAC: {
                return new MacCpuInfo();
            }
            case WINDOWS: {
                return new WindowsCpuInfo();
            }
        }
        return new OtherCpuInfo();
    }

    private static OsType determineOsType() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return OsType.WINDOWS;
        }
        if (os.contains("mac")) {
            return OsType.MAC;
        }
        if (os.contains("linux")) {
            return OsType.LINUX;
        }
        return OsType.OTHER;
    }

    private static enum OsType {
        WINDOWS,
        MAC,
        LINUX,
        OTHER;

    }
}

