/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.system.cpu.CpuInfo;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class SystemInformationAnalytics
extends ComponentSupport
implements AnalyticsMarker,
EventAware {
    private static final String NAME = "nexus.analytics.system_information";
    private final CpuInfo cpuInfo;

    @Inject
    public SystemInformationAnalytics(Provider<CpuInfo> cpuInfoProvider) {
        this.cpuInfo = (CpuInfo)((Object)cpuInfoProvider.get());
    }

    @CachedGauge(name="nexus.analytics.system_information", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> systemInformationAnalytics() {
        Runtime runtime = Runtime.getRuntime();
        return ImmutableMap.of((Object)"cpuType", (Object)this.cpuInfo.getType(), (Object)"totalMemory", (Object)runtime.totalMemory(), (Object)"availableCPUs", (Object)runtime.availableProcessors());
    }
}

