/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.nexus.licensing.ext.LicenseManager;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class SystemAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    private final ApplicationVersion applicationVersion;
    private final NodeAccess nodeAccess;
    private final DeploymentAccess deploymentAccess;
    private final LicenseManager licenseManager;

    @Inject
    public SystemAnalytics(ApplicationVersion applicationVersion, NodeAccess nodeAccess, DeploymentAccess deploymentAccess, LicenseManager licenseManager) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.deploymentAccess = (DeploymentAccess)Preconditions.checkNotNull((Object)deploymentAccess);
        this.licenseManager = (LicenseManager)Preconditions.checkNotNull((Object)licenseManager);
    }

    @CachedGauge(name="nexus.analytics.edition", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public String getEdition() {
        return this.applicationVersion.getEdition();
    }

    @CachedGauge(name="nexus.analytics.is_trial", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public boolean isTrial() {
        try {
            return this.licenseManager.getLicenseDetails().isEvaluation();
        }
        catch (Exception ex) {
            this.log.debug("Exception while getting license details for trial, assuming false", (Throwable)ex);
            return false;
        }
    }

    @CachedGauge(name="nexus.analytics.version", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public String getVersion() {
        return this.applicationVersion.getVersion();
    }

    @CachedGauge(name="nexus.analytics.nodeId", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public String getNodeId() {
        return this.nodeAccess.getId();
    }

    @CachedGauge(name="nexus.analytics.deploymentId", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public String getDeploymentId() {
        return this.deploymentAccess.getId();
    }

    @CachedGauge(name="nexus.analytics.uptime_ms", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long uptime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    @CachedGauge(name="nexus.analytics.is_clustered", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public boolean clustered() {
        return this.nodeAccess.isClustered();
    }

    @CachedGauge(name="nexus.analytics.java_version", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

