/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.httpclient.HttpClientManager;

@Named
@Singleton
public class GCPEnvironmentService
extends ComponentSupport {
    private static final String METADATA_SERVICE_URL = "http://metadata.google.internal/computeMetadata/v1/";
    private static final String METADATA_HEADER = "Metadata-Flavor";
    private static final String METADATA_HEADER_VALUE = "Google";
    private final HttpClientManager httpClientManager;
    private Boolean isGCPVM;

    @Inject
    public GCPEnvironmentService(HttpClientManager httpClientManager) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
    }

    public boolean isGCPVM() {
        if (this.isGCPVM != null) {
            return this.isGCPVM;
        }
        this.log.debug("Attempting to query the GCP metadata service at {}", (Object)METADATA_SERVICE_URL);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CloseableHttpClient httpClient = this.httpClientManager.create();){
                HttpGet httpGet = new HttpGet(METADATA_SERVICE_URL);
                httpGet.addHeader(METADATA_HEADER, METADATA_HEADER_VALUE);
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    Optional<Header> gcpMetadataHeader;
                    this.isGCPVM = false;
                    Header[] responseHeaders = response.getAllHeaders();
                    if (responseHeaders != null && (gcpMetadataHeader = Arrays.stream(response.getAllHeaders()).filter(header -> header.getName().equals(METADATA_HEADER) && header.getValue().equals(METADATA_HEADER_VALUE)).findFirst()).isPresent()) {
                        this.isGCPVM = true;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.debug("Failed to query the GCP metadata metadata service, not running in a GCP VM", (Throwable)e);
            return false;
        }
        return this.isGCPVM;
    }
}

