/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsMarker;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class CapabilityAnalytics
implements AnalyticsMarker {
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public CapabilityAnalytics(CapabilityRegistry capabilityRegistry) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
    }

    @CachedGauge(name="nexus.analytics.capabilities_enabled", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, ?>> getEnabledCapabilities() {
        return this.capabilityRegistry.getAll().stream().filter(capabilityReference -> capabilityReference.context().isEnabled()).collect(Collectors.groupingBy(capabilityReference -> capabilityReference.context().type().toString())).entrySet().stream().map(entry -> ImmutableMap.of((Object)"type", (Object)((Serializable)entry.getKey()), (Object)"count", (Object)((List)entry.getValue()).size())).collect(Collectors.toList());
    }
}

