/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.httpclient.HttpClientManager;

@Named
@Singleton
public class AzureEnvironmentService
extends ComponentSupport {
    private static final String METADATA_SERVICE_URL = "http://169.254.169.254/metadata/instance/compute?api-version=2020-06-01";
    private static final String METADATA_HEADER = "Metadata";
    private static final String METADATA_HEADER_VALUE = "true";
    private final HttpClientManager httpClientManager;
    private Boolean isAzureVM;

    @Inject
    public AzureEnvironmentService(HttpClientManager httpClientManager) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
    }

    public boolean isAzureVM() {
        if (this.isAzureVM != null) {
            return this.isAzureVM;
        }
        this.log.debug("Attempting to query the Azure instance metadata service at {}", (Object)METADATA_SERVICE_URL);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CloseableHttpClient httpClient = this.httpClientManager.create();){
                HttpGet httpGet = new HttpGet(METADATA_SERVICE_URL);
                httpGet.addHeader(METADATA_HEADER, METADATA_HEADER_VALUE);
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    int status = response.getStatusLine().getStatusCode();
                    this.log.debug("Received response with status {} from the Azure instance metadata service.", (Object)status);
                    if (response.getEntity() != null) {
                        this.log.trace("With entity {}", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                    }
                    this.isAzureVM = status == 200;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.debug("Failed to query the Azure VM instance metadata service, not running in Azure VM", (Throwable)e);
            return false;
        }
        return this.isAzureVM;
    }
}

