/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.service.orient;

import com.sonatype.analytics.internal.service.CommonQueryDataService;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.ComponentStore;

@Singleton
@Named
@Priority(value=0x7FFFFFFF)
public class OrientCommonQueryDataService
implements CommonQueryDataService {
    private final BucketStore bucketStore;
    private final ComponentStore componentStore;
    private final AssetStore assetStore;

    @Inject
    public OrientCommonQueryDataService(BucketStore bucketStore, ComponentStore componentStore, AssetStore assetStore) {
        this.bucketStore = Objects.requireNonNull(bucketStore);
        this.componentStore = Objects.requireNonNull(componentStore);
        this.assetStore = Objects.requireNonNull(assetStore);
    }

    @Override
    public long getComponentCount(Iterable<Repository> repositories) {
        return StreamSupport.stream(repositories.spliterator(), false).mapToLong(repository -> {
            Bucket bucket = this.bucketStore.read(repository.getName());
            return this.componentStore.countComponents(Collections.singleton(bucket));
        }).sum();
    }

    @Override
    public long getAssetCount(Iterable<Repository> repositories) {
        return StreamSupport.stream(repositories.spliterator(), false).mapToLong(repository -> {
            Bucket bucket = this.bucketStore.read(repository.getName());
            return this.assetStore.countAssets(Collections.singleton(bucket));
        }).sum();
    }
}

