/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.service.datastore;

import com.sonatype.analytics.internal.service.CommonQueryDataService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

@Named
@Singleton
public class DatastoreCommonQueryDataService
implements CommonQueryDataService {
    @Override
    public long getComponentCount(Iterable<Repository> repositories) {
        return this.getContentFacets(repositories).mapToLong(it -> it.components().count()).sum();
    }

    @Override
    public long getAssetCount(Iterable<Repository> repositories) {
        return this.getContentFacets(repositories).mapToLong(it -> it.assets().count()).sum();
    }

    private Stream<ContentFacet> getContentFacets(Iterable<Repository> repositories) {
        return StreamSupport.stream(repositories.spliterator(), false).filter(it -> it.optionalFacet(ContentFacet.class).isPresent()).map(it -> (ContentFacet)it.facet(ContentFacet.class));
    }
}

