/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.sonatype.analytics.AnalyticsLicenseChecker;
import com.sonatype.insight.json.store.JsonUtils;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@Singleton
public class UserTelemetryService
extends ComponentSupport {
    private static final String HDS_DEFAULT_URL = "https://clm.sonatype.com";
    private static final String HDS_URL = SystemPropertiesHelper.getString((String)"nexus.telemetry.baseurl", (String)"https://clm.sonatype.com");
    private static final String USER_TELEMETRY_ENDPOINT = "/user-telemetry/v1/";
    private static final String HDS_RESOURCE_PATH = "/rest/environment/stats";
    private static final String SEGMENT_FILE_NAME = "segment";
    private static final String SEGMENT_FILE_URL = String.valueOf(HDS_URL) + "/rest/environment/stats";
    private static final String JS_NAME = "/user-telemetry-rm.js";
    private static final String JS_FILE_URL = String.valueOf(HDS_URL) + "/user-telemetry-rm.js";
    private static final String JS_FILE_NAME = "user-telemetry.js";
    private static final String CACHE_DIR = Paths.get("tmp", "nxrm-telemetry-cache").toString();
    public static final String ID = "id";
    public static final String VERSION = "rm_serverVersion";
    public static final String BUILD = "rm_serverBuild";
    private static final HashFunction hash = Hashing.sha256();
    private static final String LICENSE_FINGERPRINT_HEADER = "X-CLM-Token";
    public static final String PRO_STARTER = "PRO-STARTER";
    private final ApplicationVersion applicationVersion;
    private final SecuritySystem securitySystem;
    private final ApplicationLicense applicationLicense;
    private HttpClient httpClient;
    private final HttpClientManager httpClientManager;
    private final File cacheDirectory;
    private final AnalyticsLicenseChecker analyticsLicenseChecker;
    private final boolean analyticsEnabled;

    @Inject
    public UserTelemetryService(ApplicationLicense applicationLicense, ApplicationVersion applicationVersion, SecuritySystem securitySystem, HttpClientManager httpClientManager, ApplicationDirectories applicationDirectories, AnalyticsLicenseChecker analyticsLicenseChecker) {
        this.applicationLicense = applicationLicense;
        this.applicationVersion = applicationVersion;
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.cacheDirectory = applicationDirectories.getWorkDirectory(CACHE_DIR);
        this.analyticsLicenseChecker = analyticsLicenseChecker;
        this.analyticsEnabled = SystemPropertiesHelper.getBoolean((String)"nexus.analytics.enabled", (boolean)true);
    }

    public UserConfig getUserConfig() {
        UserConfig userConfig = new UserConfig();
        CustomerTelemetryProperties segmentInfo = this.getCustomerTelemetryProperties();
        userConfig.account.put(ID, this.getTelemetryId(segmentInfo));
        userConfig.account.put(VERSION, this.applicationVersion.getVersion());
        userConfig.account.put(BUILD, this.applicationVersion.getBuildRevision());
        try {
            User user = this.securitySystem.currentUser();
            if (user != null && !user.getUserId().equals("anonymous")) {
                userConfig.visitor.put(ID, hash.hashUnencodedChars((CharSequence)(String.valueOf(this.getTelemetryId(segmentInfo)) + user.getName())).toString());
            }
        }
        catch (UserNotFoundException userNotFoundException) {
            this.log.error("Unable to get current user");
            throw new NotFoundException("Unable to get current user");
        }
        return userConfig;
    }

    @VisibleForTesting
    String getTelemetryId(CustomerTelemetryProperties segmentInfo) {
        Object iqAccountId = segmentInfo.segmentAttributes.get("iq_accountId");
        if (iqAccountId != null && !iqAccountId.toString().startsWith("UNKNOWN-")) {
            return iqAccountId.toString();
        }
        String companyName = "";
        if (this.applicationLicense.getAttributes().containsKey("contactCompany")) {
            companyName = (String)this.applicationLicense.getAttributes().get("contactCompany");
        }
        return hash.hashString((CharSequence)companyName, StandardCharsets.UTF_8).toString();
    }

    public Optional<byte[]> getJs() {
        try {
            if (this.isAnalyticsEnabled()) {
                return Optional.of(this.getFile(JS_FILE_NAME, JS_FILE_URL));
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to retrieve {}.", (Object)JS_FILE_NAME, (Object)e);
        }
        return Optional.empty();
    }

    private boolean isAnalyticsEnabled() {
        return (this.applicationVersion.getEdition().equals(PRO_STARTER) || Boolean.TRUE.equals(this.analyticsEnabled)) && this.analyticsLicenseChecker.analyticsSubmissionAuthorized();
    }

    byte[] getFile(String filename, String url) throws IOException {
        File file = new File(this.cacheDirectory, filename);
        if (UserTelemetryService.fileNeedsUpdating(file)) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream in = this.internalGet(url).getEntity().getContent();){
                this.log.debug("Download {}.", (Object)file.getName());
                FileUtils.copyToFile((InputStream)in, (File)file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.log.debug("Loaded from cache {}.", (Object)file.getName());
        return Files.readAllBytes(file.toPath());
    }

    @VisibleForTesting
    static boolean fileNeedsUpdating(File file) {
        return !file.exists() || System.currentTimeMillis() - file.lastModified() >= Duration.ofDays(1L).toMillis();
    }

    private HttpResponse internalGet(String url) throws IOException {
        HttpGet method = new HttpGet(url);
        return this.execute((HttpRequestBase)method);
    }

    public HttpResponse doGet(String path, HttpServletRequest request) throws IOException, URISyntaxException {
        List<NameValuePair> params = this.getParameters(request);
        HttpGet method = new HttpGet(new URIBuilder(String.valueOf(HDS_URL) + USER_TELEMETRY_ENDPOINT + path).addParameters(params).build());
        return this.execute((HttpRequestBase)method);
    }

    public HttpResponse doPost(String path, HttpServletRequest request) throws IOException, URISyntaxException {
        HttpPost method = new HttpPost(new URIBuilder(String.valueOf(HDS_URL) + USER_TELEMETRY_ENDPOINT + path).addParameters(this.getParameters(request)).build());
        method.setEntity(this.buildEntity(request));
        return this.execute((HttpRequestBase)method);
    }

    private HttpResponse execute(HttpRequestBase method) throws IOException {
        this.log.debug("sending {}", (Object)method.getURI());
        method.setHeader(LICENSE_FINGERPRINT_HEADER, this.applicationLicense.getFingerprint());
        BasicHttpContext httpContext = new BasicHttpContext();
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)method, (HttpContext)httpContext);
        this.log.debug("Server responded with status {}: size {}", (Object)response.getStatusLine(), (Object)response.getEntity().getContentLength());
        return response;
    }

    private HttpEntity buildEntity(HttpServletRequest request) throws IOException {
        return new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)request.getInputStream()));
    }

    private List<NameValuePair> getParameters(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), ((String[])entry.getValue())[0])).collect(Collectors.toList());
    }

    protected synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.httpClientManager.create();
        }
        return this.httpClient;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.log.debug("Invalidating cache after update of product license");
        this.invalidate();
    }

    private void invalidate() {
        this.deleteFileIfExists(JS_FILE_NAME);
        this.deleteFileIfExists(SEGMENT_FILE_NAME);
    }

    private void deleteFileIfExists(String filename) {
        File file = new File(this.cacheDirectory, filename);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
            this.log.debug("Deleted file {}", (Object)filename);
        }
    }

    private CustomerTelemetryProperties getCustomerTelemetryProperties() {
        try {
            return (CustomerTelemetryProperties)JsonUtils.parse((byte[])this.getFile(SEGMENT_FILE_NAME, SEGMENT_FILE_URL), CustomerTelemetryProperties.class);
        }
        catch (Exception e) {
            this.log.debug("Failed to retrieve telemetry segment properties.", (Throwable)e);
            return new CustomerTelemetryProperties();
        }
    }

    @VisibleForTesting
    static class CustomerTelemetryProperties {
        public Map<String, Object> segmentAttributes = Collections.emptyMap();

        CustomerTelemetryProperties() {
        }
    }

    public static class UserConfig {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<String, String> visitor = new HashMap<String, String>();
        public Map<String, Object> account = new HashMap<String, Object>();
    }
}

