/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.service;

import com.codahale.metrics.MetricRegistry;
import com.sonatype.analytics.internal.service.CommonQueryDataService;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Named
@Singleton
public class ContentUsageMetricHydration
extends StateGuardLifecycleSupport {
    protected final PeriodicJobService jobService;
    private final RepositoryManager repositoryManager;
    private final CommonQueryDataService commonQueryDataService;
    private final MetricRegistry metricRegistry;

    @Inject
    public ContentUsageMetricHydration(PeriodicJobService jobService, RepositoryManager repositoryManager, CommonQueryDataService commonQueryDataService, @Named(value="usage") @Named(value="usage") MetricRegistry metricRegistry) {
        this.jobService = Objects.requireNonNull(jobService);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.commonQueryDataService = Objects.requireNonNull(commonQueryDataService);
        this.metricRegistry = Objects.requireNonNull(metricRegistry);
    }

    protected void doStart() {
        this.invoke(() -> ((PeriodicJobService)this.jobService).startUsing());
        this.jobService.runOnce(() -> {
            this.doHydration();
            this.invoke(() -> ((PeriodicJobService)this.jobService).stopUsing());
        }, 1);
    }

    @Guarded(by={"STARTED"})
    protected void doHydration() {
        this.log.debug("hydration for component_total_count metric started");
        this.log.debug("component_total_count value before hydration: {}", (Object)this.metricRegistry.counter("component_total_count").getCount());
        long dbValue = this.getDbValue();
        this.log.debug("DB value of component_total_count metric for hydration : {}", (Object)dbValue);
        this.metricRegistry.counter("component_total_count").inc(dbValue);
        this.log.debug("component_total_count value after hydration: {}", (Object)this.metricRegistry.counter("component_total_count").getCount());
    }

    @Guarded(by={"STARTED"})
    private long getDbValue() {
        return this.commonQueryDataService.getComponentCount(this.repositoryManager.browse());
    }

    private void invoke(ThrowingRunnable callable) {
        try {
            callable.run();
        }
        catch (Exception e) {
            this.log.debug("Failed to start or stop using the PeriodicJobService for component_total_count metric hydration", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

