/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.rest;

import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.service.UserTelemetryService;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.HttpResponse;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/user-telemetry")
public class UserTelemetryResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/v1/user-telemetry";
    public static final String EVENTS_PATH = "events/{path:.*}";
    private final UserTelemetryService userTelemetryService;

    @Inject
    public UserTelemetryResource(UserTelemetryService userTelemetryService) {
        this.userTelemetryService = (UserTelemetryService)((Object)Preconditions.checkNotNull((Object)((Object)userTelemetryService)));
    }

    @GET
    @Path(value="javascript")
    @Produces(value={"application/javascript"})
    public Response getJavascript() {
        return this.userTelemetryService.getJs().map(js -> Response.ok((Object)js).build()).orElse(Response.ok((Object)"").build());
    }

    @GET
    @Path(value="events/{path:.*}")
    public Response proxyGet(@PathParam(value="path") String eventPath, @Context HttpServletRequest request) throws IOException, URISyntaxException {
        HttpResponse httpResponse = this.userTelemetryService.doGet(eventPath, request);
        String contentType = httpResponse.getEntity().getContentType().getValue();
        return Response.ok((Object)httpResponse.getEntity().getContent(), (String)contentType).build();
    }

    @POST
    @Path(value="events/{path:.*}")
    public Response proxyPost(@PathParam(value="path") String eventPath, @Context HttpServletRequest request) throws IOException, URISyntaxException {
        HttpResponse httpResponse = this.userTelemetryService.doPost(eventPath, request);
        String contentType = httpResponse.getEntity().getContentType().getValue();
        return Response.ok((Object)httpResponse.getEntity().getContent(), (String)contentType).build();
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public UserTelemetryService.UserConfig getConfig() {
        return this.userTelemetryService.getUserConfig();
    }
}

